/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class EventArgumentPropertyExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        HashSet coveringSents = new HashSet();
        if (arg1 instanceof EventMention) {
            coveringSents.addAll(JCasUtil.selectCovering((JCas)jCas, Sentence.class, (int)arg1.getBegin(), (int)arg1.getEnd()));
        } else if (arg2 instanceof EventMention) {
            coveringSents.addAll(JCasUtil.selectCovering((JCas)jCas, Sentence.class, (int)arg2.getBegin(), (int)arg2.getEnd()));
        } else {
            return feats;
        }
        for (Sentence coveringSent : coveringSents) {
            ArrayList<EventMention> events = JCasUtil.selectCovered(EventMention.class, (AnnotationFS)coveringSent);
            ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
            for (EventMention event : events) {
                if (!event.getClass().equals(EventMention.class)) continue;
                realEvents.add(event);
            }
            events = realEvents;
            if (events.size() <= 0) continue;
            EventMention anchor = (EventMention)events.get(0);
            if (arg1 == anchor) {
                feats.add(new Feature((Object)"Arg1LeftmostEvent"));
                continue;
            }
            if (arg2 != anchor) continue;
            feats.add(new Feature((Object)"Arg2LeftmostEvent"));
        }
        if (arg1 instanceof EventMention) {
            feats.addAll(EventArgumentPropertyExtractor.getEventFeats("mention1property", (EventMention)arg1));
        }
        if (arg2 instanceof EventMention) {
            feats.addAll(EventArgumentPropertyExtractor.getEventFeats("mention2property", (EventMention)arg2));
        }
        return feats;
    }

    private static Collection<? extends Feature> getEventFeats(String name, EventMention mention) {
        Integer typeId;
        String docTimeRel;
        Integer polarity;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        if (mention.getEvent() == null || mention.getEvent().getProperties() == null) {
            return feats;
        }
        String contextualModality = mention.getEvent().getProperties().getContextualModality();
        if (contextualModality != null) {
            feats.add(new Feature(name + "_modality", (Object)contextualModality));
        }
        if ((polarity = Integer.valueOf(mention.getEvent().getProperties().getPolarity())) != null) {
            feats.add(new Feature(name + "_polarity", (Object)polarity));
        }
        if ((docTimeRel = mention.getEvent().getProperties().getDocTimeRel()) != null) {
            feats.add(new Feature(name + "_doctimerel", (Object)docTimeRel));
        }
        if ((typeId = Integer.valueOf(mention.getEvent().getProperties().getTypeIndexID())) != null) {
            feats.add(new Feature((Object)(name + "_typeId")));
        }
        return feats;
    }
}

