/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalRelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="E-T CNN TLinker", description="Creates Event - Time TLinks with Convolutional Neural Network.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventTimeCNNAnnotator
extends CleartkAnnotator<String> {
    public static final String NO_RELATION_CATEGORY = "none";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, EventMention.class);
        HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
        if (this.isTraining()) {
            relationLookup = new HashMap();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                Annotation arg2;
                Annotation arg1 = relation.getArg1().getArgument();
                List<Annotation> key = Arrays.asList(arg1, arg2 = relation.getArg2().getArgument());
                if (relationLookup.containsKey(key)) {
                    String reln = ((BinaryTextRelation)relationLookup.get(key)).getCategory();
                    System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                    System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + reln + " at this span: " + arg1.getCoveredText() + " -- " + arg2.getCoveredText());
                    continue;
                }
                relationLookup.put(key, relation);
            }
        }
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> candidatePairs = this.getCandidateRelationArgumentPairs(jCas, sentence);
            for (TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair pair : candidatePairs) {
                String[] tokens;
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                String context = arg2.getBegin() < arg1.getBegin() ? EventTimeCNNAnnotator.getTokensBetweenExpanded(jCas, sentence, (Annotation)arg2, "t", (Annotation)arg1, "e", 5, coveringMap) : EventTimeCNNAnnotator.getTokensBetweenExpanded(jCas, sentence, (Annotation)arg1, "e", (Annotation)arg2, "t", 5, coveringMap);
                ArrayList<Feature> feats = new ArrayList<Feature>();
                for (String token : tokens = context.split(" ")) {
                    feats.add(new Feature((Object)token.toLowerCase()));
                }
                if (this.isTraining()) {
                    String category = this.getRelationCategory(relationLookup, arg1, arg2);
                    category = category == null ? NO_RELATION_CATEGORY : category.toLowerCase();
                    this.dataWriter.write(new Instance((Object)category, feats));
                    continue;
                }
                String predictedCategory = (String)this.classifier.classify(feats);
                if (predictedCategory == null || predictedCategory.equals(NO_RELATION_CATEGORY)) continue;
                if (predictedCategory.endsWith("-1")) {
                    predictedCategory = predictedCategory.substring(0, predictedCategory.length() - 2);
                    if (arg1 instanceof TimeMention) {
                        IdentifiedAnnotation temp = arg1;
                        arg1 = arg2;
                        arg2 = temp;
                    }
                } else if (arg1 instanceof EventMention) {
                    IdentifiedAnnotation temp = arg1;
                    arg1 = arg2;
                    arg2 = temp;
                }
                this.createRelation(jCas, arg1, arg2, predictedCategory.toUpperCase(), 0.0);
            }
        }
    }

    public static String getTokensBetweenExpanded(JCas jCas, Sentence sent, Annotation left, String leftType, Annotation right, String rightType, int contextSize, Map<EventMention, Collection<EventMention>> coveringMap) {
        boolean leftIsExpanded = false;
        Annotation longerLeft = left;
        if (left instanceof EventMention && (longerLeft = EventTimeCNNAnnotator.getLongerEvent(coveringMap, left)) != left) {
            leftIsExpanded = true;
        }
        boolean rightIsExpanded = false;
        Annotation longerRight = right;
        if (right instanceof EventMention && (longerRight = EventTimeCNNAnnotator.getLongerEvent(coveringMap, right)) != right) {
            rightIsExpanded = true;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        if (leftIsExpanded) {
            for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)longerLeft, (int)contextSize)) {
                if (sent.getBegin() > baseToken.getBegin()) continue;
                tokens.add(baseToken.getCoveredText());
            }
        } else {
            for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)left, (int)contextSize)) {
                if (sent.getBegin() > baseToken.getBegin()) continue;
                tokens.add(baseToken.getCoveredText());
            }
        }
        tokens.add("<" + leftType + ">");
        tokens.add(left.getCoveredText());
        tokens.add("</" + leftType + ">");
        if (leftIsExpanded) {
            for (BaseToken baseToken : JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)longerLeft, (AnnotationFS)right)) {
                tokens.add(baseToken.getCoveredText());
            }
        } else if (rightIsExpanded) {
            for (BaseToken baseToken : JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)left, (AnnotationFS)longerRight)) {
                tokens.add(baseToken.getCoveredText());
            }
        } else {
            for (BaseToken baseToken : JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)left, (AnnotationFS)right)) {
                tokens.add(baseToken.getCoveredText());
            }
        }
        tokens.add("<" + rightType + ">");
        tokens.add(right.getCoveredText());
        tokens.add("</" + rightType + ">");
        if (rightIsExpanded) {
            for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)longerRight, (int)contextSize)) {
                if (baseToken.getEnd() > sent.getEnd()) continue;
                tokens.add(baseToken.getCoveredText());
            }
        } else {
            for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)right, (int)contextSize)) {
                if (baseToken.getEnd() > sent.getEnd()) continue;
                tokens.add(baseToken.getCoveredText());
            }
        }
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    private static Annotation getLongerEvent(Map<EventMention, Collection<EventMention>> coveringMap, Annotation event) {
        int maxSpan = EventTimeCNNAnnotator.getSpan(event);
        Annotation longerEvent = event;
        Collection<EventMention> eventList = coveringMap.get(event);
        for (EventMention covEvent : eventList) {
            int span = EventTimeCNNAnnotator.getSpan((Annotation)covEvent);
            if (span <= maxSpan) continue;
            maxSpan = span;
            longerEvent = covEvent;
        }
        return longerEvent;
    }

    private static int getSpan(Annotation left) {
        return left.getEnd() - left.getBegin();
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null) {
            category = relation.getCategory();
            if (arg1 instanceof EventMention) {
                category = category + "-1";
            }
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null) {
                category = relation.getCategory();
                if (arg2 instanceof EventMention) {
                    category = category + "-1";
                }
            }
        }
        return category;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }

    private List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Sentence sentence) {
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, EventMention.class);
        ArrayList pairs = Lists.newArrayList();
        for (EventMention event : JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence)) {
            boolean eventValid = false;
            if (event.getClass().equals(EventMention.class)) {
                eventValid = true;
            }
            if (!eventValid) continue;
            if (this.isTraining()) {
                for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence)) {
                    Collection eventList = (Collection)coveringMap.get(event);
                    for (EventMention covEvent : eventList) {
                        pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)covEvent, (IdentifiedAnnotation)time));
                    }
                    pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)event, (IdentifiedAnnotation)time));
                }
                continue;
            }
            for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence)) {
                pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)event, (IdentifiedAnnotation)time));
            }
        }
        return pairs;
    }
}

