/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.features.PartOfSpeechFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.TemporalSequenceAnnotator_ImplBase;
import org.apache.ctakes.temporal.ae.feature.CheckSpecialWordRelationExtractor;
import org.apache.ctakes.temporal.ae.feature.DependencyPathFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.EventArgumentPropertyExtractor;
import org.apache.ctakes.temporal.ae.feature.OverlappedHeadFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.UmlsFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.UnexpandedTokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instances;
import org.cleartk.ml.crfsuite.CrfSuiteStringOutcomeDataWriter;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="E-E CRF TLinker", description="Creates Event - Event TLinks with Conditional Random Field.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventEventCRFRelationAnnotator
extends TemporalSequenceAnnotator_ImplBase {
    public static final String NO_RELATION_CATEGORY = "-NONE-";
    public static final String PARAM_TIMEX_VIEW = "TimexView";
    @ConfigurationParameter(name="TimexView", mandatory=false, description="View to write timexes to (used for ensemble methods)")
    protected String timexView = "_InitialView";
    public static boolean eventExpansion = false;

    public static AnalysisEngineDescription createDataWriterDescription(Class<CrfSuiteStringOutcomeDataWriter> dataWriterClass, File outputDirectory, double probabilityOfKeepingANegativeExample, boolean expandEvent) throws ResourceInitializationException {
        eventExpansion = expandEvent;
        return AnalysisEngineFactory.createEngineDescription(EventEventCRFRelationAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory, "ProbabilityOfKeepingANegativeExample", Float.valueOf((float)probabilityOfKeepingANegativeExample)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventCRFRelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventEventCRFRelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        return Lists.newArrayList((Object[])new RelationFeaturesExtractor[]{new UnexpandedTokenFeaturesExtractor(), new PartOfSpeechFeaturesExtractor(), new EventArgumentPropertyExtractor(), new UmlsFeatureExtractor(), new DependencyPathFeaturesExtractor(), new OverlappedHeadFeaturesExtractor(), new CheckSpecialWordRelationExtractor()});
    }

    @Override
    public void process(JCas jCas, Segment segment) throws AnalysisEngineProcessException {
        HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
        if (this.isTraining()) {
            relationLookup = new HashMap();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, TemporalTextRelation.class)) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                List<Annotation> key = Arrays.asList(arg1, arg2);
                if (relationLookup.containsKey(key)) {
                    String reln = ((BinaryTextRelation)relationLookup.get(key)).getCategory();
                    System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                    System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + reln + " at this span: " + arg1.getCoveredText() + " -- " + arg2.getCoveredText());
                }
                relationLookup.put(key, relation);
            }
        }
        for (Sentence sentence : JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)segment)) {
            JCas timexCas;
            ArrayList pairs = Lists.newArrayList();
            ArrayList events = new ArrayList(JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence));
            ArrayList realEvents = Lists.newArrayList();
            for (EventMention event : events) {
                if (!event.getClass().equals(EventMention.class)) continue;
                realEvents.add(event);
            }
            events = realEvents;
            int eventNum = events.size();
            for (int i = 0; i < eventNum - 1; ++i) {
                EventMention eventA = (EventMention)events.get(i);
                if (i + 1 > eventNum) continue;
                EventMention eventB = (EventMention)events.get(i + 1);
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)eventA, (IdentifiedAnnotation)eventB));
            }
            List<String> outcomes = new ArrayList();
            ArrayList allFeatures = new ArrayList();
            for (RelationExtractorAnnotator.IdentifiedAnnotationPair pair : pairs) {
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                ArrayList features = new ArrayList();
                for (RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> extractor : this.getFeatureExtractors()) {
                    List feats = extractor.extract(jCas, (Object)arg1, (Object)arg2);
                    if (feats == null) continue;
                    features.addAll(feats);
                }
                allFeatures.add(features);
                if (!this.isTraining()) continue;
                String category = this.getRelationCategory(relationLookup, arg1, arg2);
                outcomes.add(category);
            }
            if (this.isTraining()) {
                this.dataWriter.write(Instances.toInstances(outcomes, allFeatures));
                continue;
            }
            outcomes = this.classifier.classify(allFeatures);
            try {
                timexCas = jCas.getView(this.timexView);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            int idx = 0;
            for (RelationExtractorAnnotator.IdentifiedAnnotationPair pair : pairs) {
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                String predictedCategory = (String)outcomes.get(idx);
                if (!predictedCategory.equals(NO_RELATION_CATEGORY)) {
                    this.createRelation(timexCas, arg1, arg2, predictedCategory);
                }
                ++idx;
            }
        }
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null && relation instanceof TemporalTextRelation) {
            category = relation.getCategory();
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null && relation instanceof TemporalTextRelation) {
                category = relation.getCategory().equals("OVERLAP") ? relation.getCategory() : relation.getCategory() + "-1";
            }
        }
        if (category == null) {
            category = NO_RELATION_CATEGORY;
        }
        return category;
    }
}

