/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.uima.jcas.JCas;

public class MarkableTreeUtils {
    public static TreebankNode markableNode(JCas jcas, int a, int b) {
        TreebankNode lowestDom = null;
        int overage = Integer.MAX_VALUE;
        for (TreebankNode node : jcas.getJFSIndexRepository().getAnnotationIndex(TreebankNode.type)) {
            int tempOver;
            if (node.getBegin() == a && node.getEnd() == b) {
                try {
                    while (node.getParent() != null && node.getParent().getChildren().size() == 1 && !node.getParent().getNodeType().equals("TOP")) {
                        node = node.getParent();
                    }
                }
                catch (NullPointerException e) {
                    System.err.println("Null pointer exception in AttributeCalculator::markableNode()");
                }
                return node;
            }
            if (node.getBegin() > a || node.getEnd() < b || (tempOver = a - node.getBegin() + (node.getEnd() - b)) >= overage) continue;
            lowestDom = node;
            overage = tempOver;
        }
        return lowestDom;
    }

    public static Markable nodeMarkable(JCas jcas, int a, int b) {
        Markable mark = null;
        Markable best = null;
        for (Markable temp : jcas.getAnnotationIndex(Markable.type)) {
            if (temp.getBegin() == a && temp.getEnd() == b) {
                mark = temp;
                break;
            }
            if (temp.getEnd() != b || temp.getBegin() <= a || best != null && temp.getBegin() >= best.getBegin()) continue;
            best = temp;
        }
        return mark == null ? best : mark;
    }

    public static TerminalTreebankNode getHead(TreebankNode n) {
        TerminalTreebankNode ttn = null;
        int headIndex = n.getHeadIndex();
        ttn = MarkableTreeUtils.getRoot(n).getTerminals(headIndex);
        return ttn;
    }

    public static TopTreebankNode getRoot(TreebankNode n) {
        TopTreebankNode ret = null;
        while (!(n instanceof TopTreebankNode)) {
            n = n.getParent();
        }
        ret = (TopTreebankNode)n;
        return ret;
    }
}

