/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.eval;

import com.google.common.base.Function;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.assertion.medfacts.cleartk.PolarityCleartkAnalysisEngine;
import org.apache.ctakes.coreference.ae.DeterministicMarkableAnnotator;
import org.apache.ctakes.coreference.ae.MarkableSalienceAnnotator;
import org.apache.ctakes.coreference.eval.EvaluationOfEventCoreference;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.liblinear.LibLinearBooleanOutcomeDataWriter;

public class EvaluationOfMarkableSalience
extends Evaluation_ImplBase<AnnotationStatistics<Boolean>> {
    public static void main(String[] args) throws Exception {
        Evaluation_ImplBase.Options options = (Evaluation_ImplBase.Options)CliFactory.parseArguments(Evaluation_ImplBase.Options.class, (String[])args);
        List patientSets = options.getPatients().getList();
        List trainItems = EvaluationOfMarkableSalience.getTrainItems((Evaluation_ImplBase.Options)options);
        List testItems = EvaluationOfMarkableSalience.getTestItems((Evaluation_ImplBase.Options)options);
        EvaluationOfMarkableSalience eval = new EvaluationOfMarkableSalience(new File("target/eval/salience"), options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), null);
        eval.prepareXMIsFor(patientSets);
        AnnotationStatistics stats = (AnnotationStatistics)eval.trainAndTest(trainItems, testItems);
        System.out.println(stats);
        System.out.println(stats.confusions());
    }

    public EvaluationOfMarkableSalience(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory);
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(PolarityCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventCoreference.DocumentIDPrinter.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(DeterministicMarkableAnnotator.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventCoreference.RemovePersonMarkables.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(SetGoldConfidence.class, (Object[])new Object[]{"GoldViewName", "GoldView"}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{MarkableSalienceAnnotator.createDataWriterDescription(LibLinearBooleanOutcomeDataWriter.class, directory)}), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        String[] optArray = new String[]{"-s", "0", "-c", "1", "-w1", "1"};
        JarClassifierBuilder.trainAndPackage((File)directory, (String[])optArray);
    }

    protected AnnotationStatistics<Boolean> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(PolarityCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventCoreference.DocumentIDPrinter.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(DeterministicMarkableAnnotator.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventCoreference.RemovePersonMarkables.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", "PseudoGold"}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CreatePseudoGoldMarkables.class, (Object[])new Object[]{"GoldViewName", "GoldView", "PseudoViewName", "PseudoGold"}), new String[0]);
        aggregateBuilder.add(MarkableSalienceAnnotator.createAnnotatorDescription(directory.getAbsolutePath() + File.separator + "model.jar"), new String[0]);
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("PseudoGold");
            JCas systemView = jCas.getView("_InitialView");
            stats.add(JCasUtil.select((JCas)goldView, Markable.class), JCasUtil.select((JCas)systemView, Markable.class), AnnotationStatistics.annotationToSpan(), EvaluationOfMarkableSalience.mapConfidenceToBoolean());
        }
        return stats;
    }

    public static Function<Markable, Boolean> mapConfidenceToBoolean() {
        return new Function<Markable, Boolean>(){

            public Boolean apply(Markable markable) {
                return (double)markable.getConfidence() > 0.5;
            }
        };
    }

    public static class CreatePseudoGoldMarkables
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_PSEUDO_GOLD_VIEW = "PseudoViewName";
        @ConfigurationParameter(name="PseudoViewName")
        private String fakeGoldName;
        public static final String PARAM_GOLD_VIEW = "GoldViewName";
        @ConfigurationParameter(name="GoldViewName")
        private String goldViewName;

        public void process(JCas jcas) throws AnalysisEngineProcessException {
            JCas fakeView = null;
            JCas goldView = null;
            try {
                fakeView = jcas.getView(this.fakeGoldName);
                goldView = jcas.getView(this.goldViewName);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashSet<Markable> sys = new HashSet<Markable>();
            Map depIndex = JCasUtil.indexCovering((JCas)jcas, ConllDependencyNode.class, Markable.class);
            for (CollectionTextRelation goldChain : JCasUtil.select((JCas)goldView, CollectionTextRelation.class)) {
                NonEmptyFSList element;
                FSList head = goldChain.getMembers();
                block3: do {
                    Markable goldMarkable;
                    if ((goldMarkable = (Markable)(element = (NonEmptyFSList)head).getHead()).getBegin() < 0 || goldMarkable.getEnd() >= jcas.getDocumentText().length()) continue;
                    ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)goldMarkable);
                    for (Markable sysMarkable : (Collection)depIndex.get(headNode)) {
                        ConllDependencyNode markNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)sysMarkable);
                        if (markNode != headNode) continue;
                        sys.add(sysMarkable);
                        continue block3;
                    }
                } while ((head = element.getTail()) instanceof NonEmptyFSList);
            }
            for (Markable markable : JCasUtil.select((JCas)jcas, Markable.class)) {
                Markable fakeMarkable = new Markable(fakeView, markable.getBegin(), markable.getEnd());
                if (sys.contains(markable)) {
                    fakeMarkable.setConfidence(1.0f);
                } else {
                    fakeMarkable.setConfidence(0.0f);
                }
                fakeMarkable.addToIndexes();
            }
        }
    }

    public static class SetGoldConfidence
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_GOLD_VIEW = "GoldViewName";
        @ConfigurationParameter(name="GoldViewName", mandatory=true, description="View containing gold standard annotations")
        private String goldViewName;

        public void process(JCas jcas) throws AnalysisEngineProcessException {
            JCas goldView = null;
            try {
                goldView = jcas.getView(this.goldViewName);
            }
            catch (CASException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            Map depIndex = JCasUtil.indexCovering((JCas)jcas, ConllDependencyNode.class, Markable.class);
            for (CollectionTextRelation goldChain : JCasUtil.select((JCas)goldView, CollectionTextRelation.class)) {
                NonEmptyFSList element;
                FSList head = goldChain.getMembers();
                block3: do {
                    Markable goldMarkable;
                    if ((goldMarkable = (Markable)(element = (NonEmptyFSList)head).getHead()).getBegin() < 0 || goldMarkable.getEnd() >= jcas.getDocumentText().length()) continue;
                    ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)goldMarkable);
                    for (Markable sysMarkable : (Collection)depIndex.get(headNode)) {
                        ConllDependencyNode markNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)sysMarkable);
                        if (markNode != headNode) continue;
                        sysMarkable.setConfidence(1.0f);
                        continue block3;
                    }
                } while ((head = element.getTail()) instanceof NonEmptyFSList);
            }
        }
    }
}

