/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import libsvm.svm_node;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.coreference.ae.MarkableProb;
import org.apache.ctakes.coreference.type.BooleanLabeledFS;
import org.apache.ctakes.coreference.type.DemMarkable;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.type.MarkablePairSet;
import org.apache.ctakes.coreference.type.NEMarkable;
import org.apache.ctakes.coreference.type.PronounMarkable;
import org.apache.ctakes.coreference.util.AbstractClassifier;
import org.apache.ctakes.coreference.util.FSIteratorToList;
import org.apache.ctakes.coreference.util.FeatureVector;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.coreference.util.SvmVectorCreator;
import org.apache.ctakes.coreference.util.SyntaxAttributeCalculator;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.CoreferenceRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="SVM Chain Creator (MiPACQ)", description="Creates Coreferences using a Simple Vector Machine.", dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.MARKABLE}, products={PipeBitInfo.TypeProduct.COREFERENCE_RELATION})
public class MipacqSvmChainCreator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_STOPWORDS_FILENAME = "StopWords";
    @ConfigurationParameter(name="StopWords", mandatory=false, defaultValue={"org/apache/ctakes/coreference/models/stop.txt"})
    File stopwordFile = null;
    HashSet<String> stopwords;
    public static final String PARAM_FRAGS_FILENAME = "FragsFile";
    @ConfigurationParameter(name="FragsFile", mandatory=false, defaultValue={"org/apache/ctakes/coreference/models/frags.txt"})
    File treefragFile = null;
    private ArrayList<String> treeFrags;
    public static final String PARAM_COREF_MODEL = "ModelFile";
    @ConfigurationParameter(name="ModelFile", mandatory=false, defaultValue={"org/apache/ctakes/coreference/models/ne.mayo.rbf.model"})
    File modelFile = null;
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private AbstractClassifier mod_coref;
    private SvmVectorCreator vecCreator = null;

    public void initialize(UimaContext uc) throws ResourceInitializationException {
        super.initialize(uc);
        this.mod_coref = new AbstractClassifier(this.modelFile, FeatureVector.getNECorefFeatures().length + SyntaxAttributeCalculator.getNumNEFeats() - 1);
        try {
            this.stopwords = new HashSet();
            try (Scanner scanner = new Scanner(this.stopwordFile);){
                while (scanner.hasNextLine()) {
                    String l = scanner.nextLine().trim();
                    if (l.length() == 0) continue;
                    int i = l.indexOf(124);
                    if (i > 0) {
                        this.stopwords.add(l.substring(0, i).trim());
                        continue;
                    }
                    if (i >= 0) continue;
                    this.stopwords.add(l.trim());
                }
                this.logger.info((Object)("Stop words list loaded: " + this.stopwordFile.getAbsolutePath()));
                this.vecCreator = new SvmVectorCreator(this.stopwords);
            }
            this.treeFrags = new ArrayList();
            scanner = new Scanner(this.treefragFile);
            var3_4 = null;
            try {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    this.treeFrags.add(line.split(" ")[1]);
                }
                this.vecCreator.setFrags(this.treeFrags);
                this.logger.info((Object)("Tree fragment features loaded: " + this.treefragFile.getAbsolutePath()));
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var3_4 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"Error loading stop words list");
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LinkedList<Annotation> lm = FSIteratorToList.convert(jcas.getJFSIndexRepository().getAnnotationIndex(Markable.type).iterator());
        HashMap<Markable, NonEmptyFSList> collectionRas = new HashMap<Markable, NonEmptyFSList>();
        String docName = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
        this.logger.info((Object)("Classifying coreference in document: " + docName));
        int chainId = 0;
        EmptyFSList emptyList = new EmptyFSList(jcas);
        HashMap<Markable, Integer> m2q = new HashMap<Markable, Integer>();
        for (int p = 0; p < lm.size(); ++p) {
            m2q.put((Markable)lm.get(p), p);
        }
        for (MarkablePairSet set : jcas.getAnnotationIndex(MarkablePairSet.type)) {
            Markable anaphor = set.getAnaphor();
            FSList fs = set.getAntecedentList();
            MarkableProb bestAnte = null;
            LinkedList<Markable> ll = MipacqSvmChainCreator.fs2ll(fs);
            if (anaphor instanceof PronounMarkable) {
                bestAnte = new MarkableProb(null, 0.0);
            } else if (anaphor instanceof NEMarkable) {
                bestAnte = this.processNE(anaphor, ll, jcas);
            } else {
                if (!(anaphor instanceof DemMarkable)) continue;
                bestAnte = MipacqSvmChainCreator.processDem(anaphor, ll, jcas);
            }
            if (!(bestAnte.prob > 0.5)) continue;
            CoreferenceRelation cr = new CoreferenceRelation(jcas);
            cr.setCategory("Coreference");
            RelationArgument ra1 = new RelationArgument(jcas);
            ra1.setId(bestAnte.m.getId());
            ra1.setArgument(bestAnte.m.getContent());
            ra1.setRole("antecedent");
            RelationArgument ra2 = new RelationArgument(jcas);
            ra2.setId(anaphor.getId());
            ra2.setArgument(anaphor.getContent());
            ra2.setRole("anaphor");
            cr.setArg1(ra1);
            cr.setArg2(ra2);
            cr.setConfidence(bestAnte.prob.doubleValue());
            ra1.addToIndexes();
            ra2.addToIndexes();
            cr.addToIndexes();
            RelationArgument anaRa = new RelationArgument(jcas);
            anaRa.setId(anaphor.getId());
            anaRa.setArgument(anaphor.getContent());
            anaRa.setRole("mention");
            NonEmptyFSList node = new NonEmptyFSList(jcas);
            node.setHead((TOP)anaRa);
            node.setTail((FSList)emptyList);
            collectionRas.put(anaphor, node);
            NonEmptyFSList anteNode = null;
            if (collectionRas.containsKey((Object)bestAnte.m)) {
                anteNode = (NonEmptyFSList)collectionRas.get((Object)bestAnte.m);
                while (anteNode.getTail() instanceof NonEmptyFSList) {
                    anteNode = (NonEmptyFSList)anteNode.getTail();
                }
            } else {
                RelationArgument anteRa = new RelationArgument(jcas);
                anteRa.setId(bestAnte.m.getId());
                anteRa.setArgument(bestAnte.m.getContent());
                anteRa.setRole("mention");
                anteNode = new NonEmptyFSList(jcas);
                anteNode.setHead((TOP)anteRa);
                collectionRas.put(bestAnte.m, anteNode);
                CollectionTextRelation chain = new CollectionTextRelation(jcas);
                chain.setId(chainId++);
                chain.setCategory("CoreferenceChain");
                chain.setMembers((FSList)anteNode);
                chain.addToIndexes();
            }
            anteNode.setTail((FSList)node);
        }
        this.logger.info((Object)("Done classifying document: " + docName));
    }

    private static LinkedList<Markable> fs2ll(FSList fs) {
        LinkedList<Markable> ll = new LinkedList<Markable>();
        while (fs instanceof NonEmptyFSList) {
            NonEmptyFSList node = (NonEmptyFSList)fs;
            BooleanLabeledFS feat = (BooleanLabeledFS)node.getHead();
            Markable antecedent = (Markable)feat.getFeature();
            ll.add(antecedent);
            fs = node.getTail();
        }
        return ll;
    }

    private MarkableProb processNE(Markable anaphor, List<Markable> anteList, JCas jcas) {
        Markable ante = null;
        double bestProb = 0.0;
        for (Markable antecedent : anteList) {
            svm_node[] nodes = this.vecCreator.getNodeFeatures(anaphor, antecedent, jcas, true);
            double prob = 0.0;
            prob = this.mod_coref.predict(nodes);
            if (!(prob > bestProb)) continue;
            bestProb = prob;
            ante = antecedent;
        }
        return new MarkableProb(ante, bestProb);
    }

    private static MarkableProb processDem(Markable anaphor, List<Markable> anteList, JCas jcas) {
        double bestProb = 0.0;
        TreebankNode n = MarkableTreeUtils.markableNode(jcas, anaphor.getBegin(), anaphor.getEnd());
        TreebankNode parent = n != null ? n.getParent() : null;
        TreebankNode gparent = parent != null ? parent.getParent() : null;
        Markable ante = null;
        for (Markable antecedent : anteList) {
            TreebankNode anteNode;
            Markable trueAnte;
            if (n == null || parent == null || gparent == null || !n.getNodeType().equals("WHNP") || !parent.getNodeType().equals("SBAR") || !gparent.getNodeType().equals("NP") || gparent.getChildren(1) != parent || !gparent.getChildren(0).getNodeType().equals("NP") || (trueAnte = MarkableTreeUtils.nodeMarkable(jcas, (anteNode = gparent.getChildren(0)).getBegin(), anteNode.getEnd())) != antecedent) continue;
            bestProb = 1.0;
            ante = antecedent;
            break;
        }
        return new MarkableProb(ante, bestProb);
    }
}

