/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.dictionary.lookup.Dictionary;
import org.apache.ctakes.dictionary.lookup.DictionaryException;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.filter.CollectionFilter;
import org.apache.ctakes.dictionary.lookup.filter.FilterException;
import org.apache.ctakes.dictionary.lookup.filter.PostLookupFilter;
import org.apache.ctakes.dictionary.lookup.filter.PreLookupFilter;

public class DictionaryEngine {
    private final Dictionary _dictionary;
    private final boolean _keepCase;
    private List<PreLookupFilter> _preLookupFilterList = new ArrayList<PreLookupFilter>();
    private List<PostLookupFilter> _postLookupFilterList = new ArrayList<PostLookupFilter>();
    private List<CollectionFilter> _collectionFilterList = new ArrayList<CollectionFilter>();
    private Map<String, Boolean> _binaryLookupCacheMap = new HashMap<String, Boolean>();
    private Map<String, Collection<MetaDataHit>> _metaLookupCacheMap = new HashMap<String, Collection<MetaDataHit>>();

    public DictionaryEngine(Dictionary dictionary, boolean keepCase) {
        this._dictionary = dictionary;
        this._keepCase = keepCase;
    }

    public void addPreLookupFilter(PreLookupFilter preLookupFilter) {
        this._preLookupFilterList.add(preLookupFilter);
    }

    public void addPostLookupFilter(PostLookupFilter postLookupFilter) {
        this._postLookupFilterList.add(postLookupFilter);
    }

    public void addCollectionFilter(CollectionFilter collectionFilter) {
        this._collectionFilterList.add(collectionFilter);
    }

    public void addCacheEntry(String text) throws DictionaryException, FilterException {
        if (!this._keepCase) {
            text = text.toLowerCase();
        }
        boolean isHit = this.binaryLookup(text);
        this._binaryLookupCacheMap.put(text, isHit);
        Collection<MetaDataHit> metaDataHits = this.metaLookup(text);
        this._metaLookupCacheMap.put(text, metaDataHits);
    }

    public Collection<MetaDataHit> metaLookup(String text) throws DictionaryException, FilterException {
        if (!this._keepCase) {
            text = text.toLowerCase();
        }
        if (this.isFilteredByPreLookup(text)) {
            return Collections.emptySet();
        }
        Collection<MetaDataHit> metaDataHitCol = this._metaLookupCacheMap.get(text);
        if (metaDataHitCol == null) {
            metaDataHitCol = this._dictionary.getEntries(text);
        }
        if (!this._postLookupFilterList.isEmpty()) {
            HashSet<MetaDataHit> mdhRemovalSet = new HashSet<MetaDataHit>();
            for (MetaDataHit metaDataHit : metaDataHitCol) {
                if (mdhRemovalSet.contains(metaDataHit)) continue;
                for (PostLookupFilter postLookupFilter : this._postLookupFilterList) {
                    if (!postLookupFilter.contains(metaDataHit)) continue;
                    mdhRemovalSet.add(metaDataHit);
                }
            }
            metaDataHitCol.removeAll(mdhRemovalSet);
        }
        if (!this._collectionFilterList.isEmpty()) {
            for (CollectionFilter collectionFilter : this._collectionFilterList) {
                metaDataHitCol = collectionFilter.applyFilter(metaDataHitCol);
            }
        }
        return metaDataHitCol;
    }

    public boolean binaryLookup(String text) throws DictionaryException, FilterException {
        if (!this._keepCase) {
            text = text.toLowerCase();
        }
        if (this.isFilteredByPreLookup(text)) {
            return false;
        }
        Boolean isHit = this._binaryLookupCacheMap.get(text);
        if (isHit != null) {
            return isHit;
        }
        return this._dictionary.contains(text);
    }

    private boolean isFilteredByPreLookup(String text) throws FilterException {
        for (PreLookupFilter preLookupFilter : this._preLookupFilterList) {
            if (!preLookupFilter.contains(text)) continue;
            return true;
        }
        return false;
    }
}

