/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public enum CuiCodeUtil {
    INSTANCE;

    private static final Logger LOGGER;
    private static final long PREFIX_MULTIPLIER = 100000000L;
    private final List<PrefixerPair> _prefixerPairList = new ArrayList<PrefixerPair>();

    public static CuiCodeUtil getInstance() {
        return INSTANCE;
    }

    private CuiCodeUtil() {
        this._prefixerPairList.add(new PrefixerPair("C0000000"));
    }

    public String getAsCui(Long code) {
        long multiplier = code / 100000000L;
        if (code < 0L || multiplier < 0L || multiplier >= (long)this._prefixerPairList.size()) {
            LOGGER.error((Object)("Could not create Cui String for " + code));
            return "" + code;
        }
        return this._prefixerPairList.get((int)multiplier).getAsCui(code % 100000000L);
    }

    public Long getCuiCode(String cui) {
        PrefixerPair prefixerPair = new PrefixerPair(cui);
        int prefixerIndex = this._prefixerPairList.indexOf(prefixerPair);
        if (prefixerIndex < 0) {
            prefixerIndex = this._prefixerPairList.size();
            this._prefixerPairList.add(prefixerPair);
        }
        return prefixerPair.getCuiCode(cui, prefixerIndex);
    }

    static {
        LOGGER = Logger.getLogger((String)"CuiCodeUtil");
    }

    private static final class PrefixerPair {
        private final int __digitCount;
        private final char[] __prefix;
        private final int __hashCode;

        private PrefixerPair(String cui) {
            int digitCount;
            char[] chars = cui.toCharArray();
            for (digitCount = 0; digitCount < chars.length && digitCount < 7 && Character.isDigit(chars[chars.length - 1 - digitCount]); ++digitCount) {
            }
            this.__digitCount = digitCount;
            this.__prefix = Arrays.copyOfRange(chars, 0, chars.length - digitCount);
            this.__hashCode = digitCount + Arrays.hashCode(this.__prefix);
        }

        private Long getCuiCode(String cui, int multiplier) {
            String cuiNum = cui.substring(cui.length() - this.__digitCount, cui.length());
            try {
                return 100000000L * (long)multiplier + Long.parseLong(cuiNum);
            }
            catch (NumberFormatException nfE) {
                LOGGER.error((Object)("Could not create Cui Code for " + cui));
                return -1L;
            }
        }

        private String getAsCui(Long code) {
            char[] codeChars = String.valueOf(code).toCharArray();
            if (codeChars.length > this.__digitCount) {
                LOGGER.error((Object)("Invalid code " + code + " for prefix " + this.__prefix + " has more than " + this.__digitCount + " digits"));
                return String.valueOf(this.__prefix) + String.valueOf(codeChars);
            }
            int cuiLength = this.__prefix.length + this.__digitCount;
            char[] cuiChars = new char[cuiLength];
            System.arraycopy(this.__prefix, 0, cuiChars, 0, this.__prefix.length);
            System.arraycopy(codeChars, 0, cuiChars, cuiLength - codeChars.length, codeChars.length);
            for (int i = this.__prefix.length; i < cuiLength - codeChars.length; ++i) {
                cuiChars[i] = 48;
            }
            return String.valueOf(cuiChars);
        }

        public int hashCode() {
            return this.__hashCode;
        }

        public boolean equals(Object other) {
            return other instanceof PrefixerPair && this.__hashCode == ((PrefixerPair)other).__hashCode && this.__digitCount == ((PrefixerPair)other).__digitCount && Arrays.equals(this.__prefix, ((PrefixerPair)other).__prefix);
        }
    }
}

