/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.concept;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.concept.ConceptFactory;
import org.apache.ctakes.dictionary.lookup2.concept.JdbcConceptFactory;
import org.apache.ctakes.dictionary.lookup2.util.UmlsUserApprover;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public final class UmlsJdbcConceptFactory
implements ConceptFactory {
    private static final Logger LOGGER = Logger.getLogger((String)"UmlsJdbcConceptFactory");
    private final ConceptFactory _delegateConceptFactory;

    public UmlsJdbcConceptFactory(String name, UimaContext uimaContext, Properties properties) throws SQLException {
        boolean isValidUser = UmlsUserApprover.getInstance().isValidUMLSUser(uimaContext, properties);
        if (!isValidUser) {
            throw new SQLException("Invalid User for UMLS Concept Factory " + name);
        }
        this._delegateConceptFactory = new JdbcConceptFactory(name, uimaContext, properties);
    }

    @Override
    public String getName() {
        return this._delegateConceptFactory.getName();
    }

    @Override
    public Concept createConcept(Long cuiCode) {
        return this._delegateConceptFactory.createConcept(cuiCode);
    }

    @Override
    public Map<Long, Concept> createConcepts(Collection<Long> cuiCodes) {
        return this._delegateConceptFactory.createConcepts(cuiCodes);
    }
}

