/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public final class OntologyConceptUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"IdentifiedAnnotationUtil");
    private static final FeatureStructure[] EMPTY_FEATURE_ARRAY = new FeatureStructure[0];
    private static final Predicate<OntologyConcept> isSchemeOk = concept -> concept.getCodingScheme() != null && !concept.getCodingScheme().isEmpty();
    private static final Predicate<OntologyConcept> isCodeOk = concept -> concept.getCode() != null && !concept.getCode().isEmpty();
    private static final Function<OntologyConcept, Collection<String>> getCodeAsSet = concept -> new HashSet<String>(Collections.singletonList(concept.getCode()));
    private static final BinaryOperator<Collection<String>> mergeSets = (set1, set2) -> {
        set1.addAll(set2);
        return set1;
    };

    private OntologyConceptUtil() {
    }

    public static FeatureStructure[] getConceptFeatureStructures(IdentifiedAnnotation annotation) {
        if (annotation == null) {
            return EMPTY_FEATURE_ARRAY;
        }
        FSArray ontologyConcepts = annotation.getOntologyConceptArr();
        if (ontologyConcepts == null) {
            return EMPTY_FEATURE_ARRAY;
        }
        return ontologyConcepts.toArray();
    }

    public static Stream<OntologyConcept> getOntologyConceptStream(IdentifiedAnnotation annotation) {
        return Arrays.stream(OntologyConceptUtil.getConceptFeatureStructures(annotation)).filter(OntologyConcept.class::isInstance).map(fs -> (OntologyConcept)fs).filter(isSchemeOk).filter(isCodeOk);
    }

    public static Collection<OntologyConcept> getOntologyConcepts(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getOntologyConceptStream(annotation).collect(Collectors.toSet());
    }

    public static Stream<UmlsConcept> getUmlsConceptStream(IdentifiedAnnotation annotation) {
        return Arrays.stream(OntologyConceptUtil.getConceptFeatureStructures(annotation)).filter(UmlsConcept.class::isInstance).map(fs -> (UmlsConcept)fs);
    }

    public static Collection<UmlsConcept> getUmlsConcepts(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getUmlsConceptStream(annotation).collect(Collectors.toSet());
    }

    public static Collection<String> getCuis(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getUmlsConceptStream(annotation).map(UmlsConcept::getCui).collect(Collectors.toSet());
    }

    public static Collection<String> getTuis(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getUmlsConceptStream(annotation).map(UmlsConcept::getTui).collect(Collectors.toSet());
    }

    public static Map<String, Collection<String>> getSchemeCodes(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getOntologyConceptStream(annotation).collect(Collectors.toMap(OntologyConcept::getCodingScheme, getCodeAsSet, mergeSets));
    }

    public static Collection<String> getCodes(IdentifiedAnnotation annotation) {
        return OntologyConceptUtil.getOntologyConceptStream(annotation).map(OntologyConcept::getCode).collect(Collectors.toSet());
    }

    public static Collection<String> getCodes(IdentifiedAnnotation annotation, String schemeName) {
        return OntologyConceptUtil.getOntologyConceptStream(annotation).filter(concept -> schemeName.equalsIgnoreCase(concept.getCodingScheme())).map(OntologyConcept::getCode).collect(Collectors.toSet());
    }

    public static Collection<String> getCuis(JCas jcas) {
        return OntologyConceptUtil.getCuis(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class));
    }

    public static Map<String, Long> getCuiCounts(JCas jcas) {
        return OntologyConceptUtil.getCuiCounts(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class));
    }

    public static Collection<String> getTuis(JCas jcas) {
        return OntologyConceptUtil.getTuis(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class));
    }

    public static Map<String, Collection<String>> getSchemeCodes(JCas jcas) {
        return OntologyConceptUtil.getSchemeCodes(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class));
    }

    public static Collection<String> getCodes(JCas jcas) {
        return OntologyConceptUtil.getCodes(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class));
    }

    public static Collection<String> getCodes(JCas jcas, String schemeName) {
        return OntologyConceptUtil.getCodes(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class), schemeName);
    }

    public static <T extends Annotation> Collection<String> getCuis(JCas jcas, T lookupWindow) {
        return OntologyConceptUtil.getCuis(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow));
    }

    public static <T extends Annotation> Collection<String> getTuis(JCas jcas, T lookupWindow) {
        return OntologyConceptUtil.getTuis(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow));
    }

    public static <T extends Annotation> Map<String, Collection<String>> getSchemeCodes(JCas jcas, T lookupWindow) {
        return OntologyConceptUtil.getSchemeCodes(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow));
    }

    public static <T extends Annotation> Collection<String> getCodes(JCas jcas, T lookupWindow) {
        return OntologyConceptUtil.getCodes(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow));
    }

    public static <T extends Annotation> Collection<String> getCodes(JCas jcas, T lookupWindow, String schemeName) {
        return OntologyConceptUtil.getCodes(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow), schemeName);
    }

    public static Collection<String> getCuis(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().map(OntologyConceptUtil::getCuis).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Map<String, Long> getCuiCounts(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().map(OntologyConceptUtil::getCuis).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    public static Collection<String> getTuis(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().map(OntologyConceptUtil::getTuis).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Map<String, Collection<String>> getSchemeCodes(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().map(OntologyConceptUtil::getSchemeCodes).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeSets));
    }

    public static Collection<String> getCodes(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().map(OntologyConceptUtil::getCodes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Collection<String> getCodes(Collection<IdentifiedAnnotation> annotations, String schemeName) {
        return annotations.stream().map(annotation -> OntologyConceptUtil.getCodes(annotation, schemeName)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Collection<IdentifiedAnnotation> getAnnotationsByCui(JCas jcas, String cui) {
        return OntologyConceptUtil.getAnnotationsByCui(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class), cui);
    }

    public static Collection<IdentifiedAnnotation> getAnnotationsByTui(JCas jcas, String tui) {
        return OntologyConceptUtil.getAnnotationsByTui(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class), tui);
    }

    public static Collection<IdentifiedAnnotation> getAnnotationsByCode(JCas jcas, String code) {
        return OntologyConceptUtil.getAnnotationsByCode(JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class), code);
    }

    public static <T extends Annotation> Collection<IdentifiedAnnotation> getAnnotationsByCui(JCas jcas, T lookupWindow, String cui) {
        return OntologyConceptUtil.getAnnotationsByCui(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow), cui);
    }

    public static <T extends Annotation> Collection<IdentifiedAnnotation> getAnnotationsByTui(JCas jcas, T lookupWindow, String tui) {
        return OntologyConceptUtil.getAnnotationsByTui(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow), tui);
    }

    public static <T extends Annotation> Collection<IdentifiedAnnotation> getAnnotationsByCode(JCas jcas, T lookupWindow, String code) {
        return OntologyConceptUtil.getAnnotationsByCode(JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, lookupWindow), code);
    }

    public static Collection<IdentifiedAnnotation> getAnnotationsByCui(Collection<IdentifiedAnnotation> annotations, String cui) {
        return annotations.stream().filter(annotation -> OntologyConceptUtil.getCuis(annotation).contains(cui)).collect(Collectors.toSet());
    }

    public static Collection<IdentifiedAnnotation> getAnnotationsByTui(Collection<IdentifiedAnnotation> annotations, String tui) {
        return annotations.stream().filter(annotation -> OntologyConceptUtil.getTuis(annotation).contains(tui)).collect(Collectors.toSet());
    }

    public static Collection<IdentifiedAnnotation> getAnnotationsByCode(Collection<IdentifiedAnnotation> annotations, String code) {
        return annotations.stream().filter(annotation -> OntologyConceptUtil.getCodes(annotation).contains(code)).collect(Collectors.toSet());
    }
}

