/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.cell;

import org.apache.ctakes.core.cc.pretty.cell.AbstractItemCell;
import org.apache.ctakes.core.cc.pretty.textspan.TextSpan;

public class EventCell
extends AbstractItemCell {
    private static final int EVENT_SPAN = 5;
    private static final String EVENT_TEXT = "Event";
    private static final int NEGATED_SPAN = 8;
    private static final String NEGATED_TEXT = "Negated";
    private final boolean _negated;

    public EventCell(TextSpan textSpan, int polarity) {
        super(textSpan);
        this._negated = polarity < 0;
    }

    @Override
    public int getWidth() {
        return Math.max(this.getTextSpan().getWidth(), this.isNegated() ? 8 : 5);
    }

    @Override
    public int getHeight() {
        return 2 + (this.isNegated() ? 1 : 0);
    }

    @Override
    public String getText() {
        return "ENTITY_FILL";
    }

    public boolean isNegated() {
        return this._negated;
    }

    @Override
    public String getLineText(int lineIndex) {
        switch (lineIndex) {
            case 0: {
                return "ENTITY_FILL";
            }
            case 1: {
                return EVENT_TEXT;
            }
            case 2: {
                if (!this.isNegated()) break;
                return NEGATED_TEXT;
            }
        }
        return "";
    }

    public boolean equals(Object other) {
        return other instanceof EventCell && this.getTextSpan().equals(((EventCell)other).getTextSpan()) && this.isNegated() == ((EventCell)other).isNegated();
    }

    public int hashCode() {
        return 2 * this.getTextSpan().hashCode() + (this.isNegated() ? 1 : 0);
    }
}

