/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import findstruct.Section;
import findstruct.StructFinder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.DocumentSection;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Sectionizer", description="Annotates Document Sections by detecting Section Headers in template.", products={PipeBitInfo.TypeProduct.SECTION})
public class SectionSegmentAnnotator
extends JCasAnnotator_ImplBase {
    private String segmentId;
    private StructFinder structureFinder;
    private String templateFile = null;
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    public HashMap<Integer, DocumentSection> sections;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.templateFile = ((FileResource)aContext.getResourceObject("template")).getFile().getAbsolutePath();
            this.structureFinder = new StructFinder();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error reading template file: " + e.getMessage()));
        }
        this.segmentId = (String)aContext.getConfigParameterValue("SegmentID");
        if (this.segmentId == null) {
            this.segmentId = "SIMPLE_SEGMENT";
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String text = jCas.getDocumentText();
        if (text == null) {
            String docId = DocumentIDAnnotationUtil.getDocumentID(jCas);
            throw new AnalysisEngineProcessException("text is null for docId=" + docId, null);
        }
        try {
            ArrayList foundSections = this.structureFinder.execute(text, (InputStream)new FileInputStream(this.templateFile));
            int index = 0;
            for (Section sct : foundSections) {
                String nodeName = sct.getHeader();
                String content = sct.getContent();
                if (nodeName == null || nodeName.trim().isEmpty() || content == null || content.trim().isEmpty()) continue;
                index = text.indexOf(content, index);
                Segment segment = new Segment(jCas);
                segment.setBegin(index);
                segment.setEnd(index + content.length());
                segment.setId(sct.getHeader());
                segment.addToIndexes();
                index += content.length();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Segment seg = new Segment(jCas);
            seg.setBegin(0);
            seg.setEnd(text.length());
            seg.setId(this.segmentId);
            seg.addToIndexes();
        }
    }
}

