/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.ctakes.core.ae.RegexSectionizer;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Regex Sectionizer", description="Annotates Document Sections by detecting Section Headers using Regular Expressions provided in a Bar-Separated-Value (BSV) File.", products={PipeBitInfo.TypeProduct.SECTION})
public class BsvRegexSectionizer
extends RegexSectionizer {
    private static final Logger LOGGER = Logger.getLogger((String)"BsvRegexSectionizer");
    public static final String SECTION_TYPES_PATH = "SectionsBsv";
    public static final String SECTION_TYPES_DESC = "path to a BSV file containing a list of regular expressions and corresponding section types.";
    @ConfigurationParameter(name="SectionsBsv", description="path to a BSV file containing a list of regular expressions and corresponding section types.")
    private String _sectionTypesPath;

    @Override
    protected void loadSections() throws ResourceInitializationException {
        if (this._sectionTypesPath == null) {
            LOGGER.error((Object)"No path to a BSV file containing a list of regular expressions and corresponding section types.");
            return;
        }
        LOGGER.info((Object)("Parsing " + this._sectionTypesPath));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileLocator.getAsStream(this._sectionTypesPath)));){
            String line = reader.readLine();
            while (line != null) {
                BsvRegexSectionizer.parseBsvLine(line);
                line = reader.readLine();
            }
        }
        catch (IOException ioE) {
            throw new ResourceInitializationException((Throwable)ioE);
        }
        LOGGER.info((Object)"Finished Parsing");
    }

    private static void parseBsvLine(String line) {
        if (line.isEmpty() || line.startsWith("#") || line.startsWith("//")) {
            return;
        }
        String[] splits = line.split("\\|\\|");
        if (splits.length < 2 || BsvRegexSectionizer.isBoolean(splits[1])) {
            LOGGER.warn((Object)("Bad Section definition: " + line + " ; please use one of the following:\n" + "NAME||HEADER_REGEX\n" + "NAME||HEADER_REGEX||SHOULD_PARSE(true/false)\n" + "NAME||HEADER_REGEX||FOOTER_REGEX\n" + "NAME||HEADER_REGEX||FOOTER_REGEX||SHOULD_PARSE(true/false)\n" + "The regex may contain \"(?<SECTION_NAME>regex_for_custom_section_name)\""));
            return;
        }
        String name = splits[0].trim();
        String lastColumn = splits[splits.length - 1].trim().toLowerCase();
        boolean shouldParse = !lastColumn.equalsIgnoreCase("false");
        String headerRegex = splits[1].trim();
        String footerRegex = null;
        if (splits.length > 2 && !BsvRegexSectionizer.isBoolean(splits[2])) {
            footerRegex = splits[2].trim();
        }
        RegexSectionizer.SectionType sectionType = new RegexSectionizer.SectionType(name, headerRegex, footerRegex, shouldParse);
        BsvRegexSectionizer.addSectionType(sectionType);
    }

    public static AnalysisEngineDescription createEngineDescription(String sectionTypesPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(BsvRegexSectionizer.class, (Object[])new Object[]{SECTION_TYPES_PATH, sectionTypesPath});
    }
}

