/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.ctakes.dependency.parser.util.DependencyPath;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public abstract class DependencyUtility {
    public static Logger logger = Logger.getLogger((String)"org.apache.ctakes.dependency.parser.util.DependencyUtility");

    public static void addToIndexes(JCas jcas, ArrayList<ConllDependencyNode> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            nodes.get(i).addToIndexes(jcas);
        }
    }

    public static boolean equalCoverage(Annotation annot1, Annotation annot2) {
        if (annot1 == null || annot2 == null) {
            return false;
        }
        return annot1.getBegin() == annot2.getBegin() && annot1.getEnd() == annot2.getEnd() && annot1.getCoveredText().equals(annot2.getCoveredText());
    }

    public static boolean doesSubsume(Annotation annot1, Annotation annot2) {
        if (annot1 == null || annot2 == null) {
            return false;
        }
        return annot1.getBegin() <= annot2.getBegin() && annot1.getEnd() >= annot2.getEnd() && annot1.getCoveredText().contains(annot2.getCoveredText());
    }

    public static Sentence getSentence(JCas jCas, Annotation annot) {
        for (Sentence sentence : jCas.getAnnotationIndex(Sentence.type)) {
            if (!DependencyUtility.doesSubsume((Annotation)sentence, annot)) continue;
            return sentence;
        }
        return null;
    }

    public static ConllDependencyNode getDependencyNode(JCas jCas, Annotation annot) {
        AnnotationIndex nodeIndex = jCas.getAnnotationIndex(ConllDependencyNode.type);
        for (ConllDependencyNode node : nodeIndex) {
            if (!DependencyUtility.equalCoverage(annot, (Annotation)node)) continue;
            return node;
        }
        return null;
    }

    public static List<ConllDependencyNode> getDependencyNodes(JCas jCas, Annotation annot) {
        ArrayList<ConllDependencyNode> output = new ArrayList<ConllDependencyNode>();
        AnnotationIndex nodeIndex = jCas.getAnnotationIndex(ConllDependencyNode.type);
        for (ConllDependencyNode node : nodeIndex) {
            if (!DependencyUtility.doesSubsume(annot, (Annotation)node)) continue;
            output.add(node);
        }
        return output;
    }

    public static ConllDependencyNode getNominalHeadNode(JCas jCas, Annotation annot) {
        List<ConllDependencyNode> nodes = DependencyUtility.getDependencyNodes(jCas, annot);
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        return DependencyUtility.getNominalHeadNode(nodes);
    }

    public static ConllDependencyNode getNominalHeadNode(List<ConllDependencyNode> nodes) {
        int i;
        ArrayList<ConllDependencyNode> anodes = new ArrayList<ConllDependencyNode>(nodes);
        Boolean[][] matrixofheads = new Boolean[anodes.size()][anodes.size()];
        ArrayList<ConllDependencyNode> outnodes = new ArrayList<ConllDependencyNode>();
        for (i = 0; i < anodes.size(); ++i) {
            if (anodes.get(i).getId() != 0) continue;
            anodes.remove(i);
        }
        for (int id1 = 0; id1 < anodes.size(); ++id1) {
            for (int id2 = 0; id2 < anodes.size(); ++id2) {
                matrixofheads[id2][id1] = id1 == id2 || anodes.get(id1).getId() != anodes.get(id2).getHead().getId() ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
        }
        for (int idhd = 0; idhd < anodes.size(); ++idhd) {
            boolean occupiedCol = false;
            for (int row = 0; row < anodes.size(); ++row) {
                if (!matrixofheads[row][idhd].booleanValue()) continue;
                occupiedCol = true;
            }
            if (!occupiedCol) continue;
            boolean occupiedRow = false;
            for (int col = 0; col < anodes.size(); ++col) {
                if (!matrixofheads[idhd][col].booleanValue()) continue;
                occupiedRow = true;
            }
            if (occupiedRow) continue;
            outnodes.add(anodes.get(idhd));
        }
        if (outnodes.isEmpty()) {
            for (i = 0; i < anodes.size(); ++i) {
                if (!Pattern.matches("N..?", anodes.get(i).getPostag())) continue;
                return anodes.get(i);
            }
            return anodes.get(anodes.size() - 1);
        }
        for (i = 0; i < outnodes.size(); ++i) {
            if (!Pattern.matches("N..?", ((ConllDependencyNode)outnodes.get(i)).getPostag())) continue;
            return (ConllDependencyNode)outnodes.get(i);
        }
        return (ConllDependencyNode)outnodes.get(outnodes.size() - 1);
    }

    public static DependencyPath getPath(List<ConllDependencyNode> nodes, ConllDependencyNode node1, ConllDependencyNode node2) {
        DependencyPath pathUp1 = new DependencyPath();
        DependencyPath pathUp2 = new DependencyPath();
        DependencyPath pathLtoR = new DependencyPath();
        DependencyPath pathRtoL = new DependencyPath();
        if (node1 == null || node2 == null) {
            System.err.println(" WARNING: looking for path between null nodes.");
            return null;
        }
        pathUp1.add(node1);
        while (node1.getHead() != null) {
            node1 = node1.getHead();
            pathUp1.add(node1);
        }
        pathUp2.add(node2);
        while (node2.getHead() != null) {
            node2 = node2.getHead();
            pathUp2.add(node2);
        }
        pathLtoR.clear();
        boolean foundMatch = false;
        for (int i = 0; i < pathUp1.size(); ++i) {
            ConllDependencyNode nodeUp1 = (ConllDependencyNode)pathUp1.get(i);
            pathLtoR.add(nodeUp1);
            pathRtoL.clear();
            for (int j = 0; j < pathUp2.size(); ++j) {
                ConllDependencyNode nodeUp2 = (ConllDependencyNode)pathUp2.get(j);
                if (DependencyUtility.equalCoverage((Annotation)nodeUp1, (Annotation)nodeUp2)) {
                    pathLtoR.setCommonNode(nodeUp1);
                    pathLtoR.addAll(pathRtoL);
                    foundMatch = true;
                    break;
                }
                pathRtoL.addFirst(nodeUp2);
            }
            if (!foundMatch) continue;
            return pathLtoR;
        }
        return null;
    }

    public static DependencyPath getPath(JCas jCas, ConllDependencyNode node1, ConllDependencyNode node2) {
        Sentence sent2;
        Sentence sent1 = DependencyUtility.getSentence(jCas, (Annotation)node1);
        if (sent1.equals((Object)(sent2 = DependencyUtility.getSentence(jCas, (Annotation)node2)))) {
            return DependencyUtility.getPath(DependencyUtility.getDependencyNodes(jCas, (Annotation)sent1), node1, node2);
        }
        String node1txt = node1 == null ? "null" : node1.getCoveredText();
        String node2txt = node2 == null ? "null" : node2.getCoveredText();
        logger.debug((Object)String.format("Cannot find path between nodes in different sentences. Node1: %s  Node2: %s", node1txt, node2txt));
        return null;
    }

    public static DependencyPath getPathToTop(JCas jCas, ConllDependencyNode node1) {
        DependencyPath pathUp1 = new DependencyPath();
        if (node1 == null) {
            System.err.println(" WARNING: looking for path between null nodes.");
            return null;
        }
        pathUp1.add(node1);
        while (node1.getHead() != null) {
            node1 = node1.getHead();
            pathUp1.add(node1);
        }
        return pathUp1;
    }

    public static List<ConllDependencyNode> getRightSibs(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        ConllDependencyNode parent = refNode.getHead();
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        for (ConllDependencyNode node : tree.subList(tree.indexOf(refNode) + 1, tree.size())) {
            if (!node.getHead().equals((Object)parent)) continue;
            out.add(node);
        }
        return out;
    }

    public static List<ConllDependencyNode> getLeftSibs(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        ConllDependencyNode parent = refNode.getHead();
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        List<ConllDependencyNode> lSide = tree.subList(0, tree.indexOf(refNode));
        for (int i = tree.indexOf(refNode) - 1; i >= 0; --i) {
            ConllDependencyNode node = lSide.get(i);
            if (!node.getHead().equals((Object)parent)) continue;
            out.add(node);
        }
        return out;
    }

    public static List<ConllDependencyNode> getProgeny(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        block0: for (ConllDependencyNode node : tree) {
            if (node.equals((Object)refNode)) {
                out.add(node);
                continue;
            }
            ConllDependencyNode upNode = node;
            while (upNode.getHead() != null) {
                if (!(upNode = upNode.getHead()).equals((Object)refNode)) continue;
                out.add(node);
                continue block0;
            }
        }
        return out;
    }

    public static List<ConllDependencyNode> getProgeny(List<ConllDependencyNode> refNodes, List<ConllDependencyNode> tree) {
        ArrayList<ConllDependencyNode> out = new ArrayList<ConllDependencyNode>();
        block0: for (ConllDependencyNode node : tree) {
            if (refNodes.contains(node)) {
                out.add(node);
                continue;
            }
            ConllDependencyNode upNode = node;
            while (upNode.getHead() != null) {
                if (!refNodes.contains(upNode = upNode.getHead())) continue;
                out.add(node);
                continue block0;
            }
        }
        return out;
    }

    public static List<ConllDependencyNode> getRightSibProgeny(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        return DependencyUtility.getProgeny(DependencyUtility.getRightSibs(refNode, tree), tree);
    }

    public static List<ConllDependencyNode> getLeftSibProgeny(ConllDependencyNode refNode, List<ConllDependencyNode> tree) {
        return DependencyUtility.getProgeny(DependencyUtility.getLeftSibs(refNode, tree), tree);
    }

    public static String dumpDependencyGraph(Annotation annotation) {
        StringBuilder builder = new StringBuilder();
        for (ConllDependencyNode depNode : JCasUtil.selectCovered(ConllDependencyNode.class, (AnnotationFS)annotation)) {
            ConllDependencyNode head = depNode.getHead();
            String headStr = head != null ? head.getCoveredText() : "TOP";
            builder.append(String.format("%s(%s, %s)\n", depNode.getDeprel(), depNode.getCoveredText(), headStr));
        }
        return builder.toString();
    }
}

