/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser.util;

import com.googlecode.clearnlp.dependency.DEPNode;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.dependency.parser.util.Delim;
import org.apache.ctakes.dependency.parser.util.DependencyPath;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;

public class DependencyRegex {
    public static String ANY_TOKEN = "[^" + Delim.R_TOK_DELIM + "]*";
    public static String ANY_DEPREL = "[^" + Delim.R_REL_DELIM + "]*";
    public static String ANY_POS = "\\w*";
    public static String ANY_NOUN = "N..?";
    public static String ANY_VERB = "V..?";
    public static String ANY_ADJECTIVE = "J..?";
    private static String L_TOK_DELIM = DependencyRegex.metaReplace(Delim.L_TOK_DELIM);
    private static String R_TOK_DELIM = DependencyRegex.metaReplace(Delim.R_TOK_DELIM);
    private static String L_POS_DELIM = DependencyRegex.metaReplace(Delim.L_POS_DELIM);
    private static String R_POS_DELIM = DependencyRegex.metaReplace(Delim.R_POS_DELIM);
    private static String L_REL_DELIM = DependencyRegex.metaReplace(Delim.L_REL_DELIM);
    private static String R_REL_DELIM = DependencyRegex.metaReplace(Delim.R_REL_DELIM);
    private static String UP_ARC_A = DependencyRegex.metaReplace(Delim.UP_ARC_A);
    private static String UP_ARC_B = DependencyRegex.metaReplace(Delim.UP_ARC_B);
    private static String DN_ARC_A = DependencyRegex.metaReplace(Delim.DN_ARC_A);
    private static String DN_ARC_B = DependencyRegex.metaReplace(Delim.DN_ARC_B);
    private Pattern regex;
    private String name = "";

    public static String fromSet(Set<String> okwords) {
        StringBuilder str = new StringBuilder();
        Iterator<String> it = okwords.iterator();
        if (it.hasNext()) {
            str.append("((?:" + it.next() + ")");
        }
        while (it.hasNext()) {
            str.append("|(?:" + it.next() + ")");
        }
        if (str.toString() != "") {
            str.append(")");
        }
        return str.toString();
    }

    public DependencyRegex(String name, String dummy) {
        this.name = name;
    }

    public DependencyRegex(DependencyPath path, String name) {
        Pattern regex;
        String str = path.toString();
        this.regex = regex = Pattern.compile(str, 2);
        this.name = name;
    }

    public DependencyRegex(String str) {
        this.regex = this.compile(str, 2);
    }

    public String getName() {
        return this.name;
    }

    public DependencyRegex(DEPNode[] regnodes, int commonNodeIndex) {
        this(regnodes, commonNodeIndex, "");
    }

    public DependencyRegex(DEPNode[] regnodes, int commonNodeIndex, String name) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < regnodes.length; ++i) {
            if (regnodes[i].form == null) {
                regnodes[i].form = ANY_TOKEN;
            }
            if (regnodes[i].pos == null) {
                regnodes[i].pos = ANY_POS;
            }
            if (regnodes[i].getLabel() == null) {
                regnodes[i].setLabel(ANY_DEPREL);
            }
            if (i == commonNodeIndex - 1) {
                str.append(L_TOK_DELIM + regnodes[i].form + R_TOK_DELIM);
                str.append(L_POS_DELIM + regnodes[i].pos + R_POS_DELIM);
                continue;
            }
            str.append(i >= commonNodeIndex - 1 ? DN_ARC_A + L_REL_DELIM + regnodes[i].getLabel() + R_REL_DELIM + DN_ARC_B + L_TOK_DELIM + regnodes[i].form + R_TOK_DELIM + L_POS_DELIM + regnodes[i].pos + R_POS_DELIM : L_TOK_DELIM + regnodes[i].form + R_TOK_DELIM + L_POS_DELIM + regnodes[i].pos + R_POS_DELIM + UP_ARC_B + L_REL_DELIM + regnodes[i].getLabel() + R_REL_DELIM + UP_ARC_A);
        }
        this.regex = this.compile(str.toString(), 2);
        this.name = name;
    }

    public DependencyRegex(ConllDependencyNode[] regnodes, int commonNodeIndex) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < regnodes.length; ++i) {
            if (regnodes[i].getForm() == null) {
                regnodes[i].setForm(ANY_TOKEN);
            }
            if (regnodes[i].getPostag() == null) {
                regnodes[i].setPostag(ANY_POS);
            }
            if (regnodes[i].getDeprel() == null) {
                regnodes[i].setDeprel(ANY_DEPREL);
            }
            if (i == commonNodeIndex - 1) {
                str.append(L_TOK_DELIM + regnodes[i].getForm() + R_TOK_DELIM);
                str.append(L_POS_DELIM + regnodes[i].getPostag() + R_POS_DELIM);
                continue;
            }
            str.append(i >= commonNodeIndex - 1 ? DN_ARC_A + L_REL_DELIM + regnodes[i].getDeprel() + R_REL_DELIM + DN_ARC_B + L_TOK_DELIM + regnodes[i].getForm() + R_TOK_DELIM + L_POS_DELIM + regnodes[i].getPostag() + R_POS_DELIM : L_TOK_DELIM + regnodes[i].getForm() + R_TOK_DELIM + L_POS_DELIM + regnodes[i].getPostag() + R_POS_DELIM + UP_ARC_B + L_REL_DELIM + regnodes[i].getDeprel() + R_REL_DELIM + UP_ARC_A);
        }
        this.regex = this.compile(str.toString(), 2);
    }

    private static String metaReplace(String str) {
        str = Pattern.compile("\\{").matcher(str).replaceAll("\\\\{");
        str = Pattern.compile("\\}").matcher(str).replaceAll("\\\\}");
        str = Pattern.compile("\\[").matcher(str).replaceAll("\\\\[");
        str = Pattern.compile("\\]").matcher(str).replaceAll("\\\\]");
        str = Pattern.compile("\\+").matcher(str).replaceAll("\\\\+");
        str = Pattern.compile("\\*").matcher(str).replaceAll("\\\\*");
        str = Pattern.compile("\\(").matcher(str).replaceAll("\\\\(");
        str = Pattern.compile("\\)").matcher(str).replaceAll("\\\\)");
        str = Pattern.compile("\\^").matcher(str).replaceAll("\\\\^");
        str = Pattern.compile("\\$").matcher(str).replaceAll("\\\\$");
        str = Pattern.compile("\\.").matcher(str).replaceAll("\\\\.");
        return str;
    }

    public Pattern compile(String str) {
        return Pattern.compile(str, 2);
    }

    public Pattern compile(String str, int flag) {
        return Pattern.compile(str, flag);
    }

    public String get() {
        return this.regex.toString();
    }

    public String toString() {
        return this.regex.toString();
    }

    public Matcher matcher(CharSequence input) {
        return this.regex.matcher(input);
    }

    public boolean matches(String str) {
        Matcher matcher = this.regex.matcher(str);
        boolean flag = matcher.matches();
        return flag;
    }

    public boolean find(String str) {
        Matcher matcher = this.regex.matcher(str);
        boolean flag = matcher.find();
        return flag;
    }

    public String[] split(CharSequence input) {
        return this.regex.split(input);
    }

    public DependencyRegex append(DependencyRegex dregex) {
        DependencyRegex newregex = new DependencyRegex(this.name + "_mod", null);
        newregex.regex = this.compile(this.toString() + dregex.toString(), 2);
        return newregex;
    }

    public DependencyRegex appendOptional(DependencyRegex dregex) {
        DependencyRegex newregex = new DependencyRegex(this.name + "_mod", null);
        newregex.regex = this.compile(this.toString() + "(" + dregex.toString() + ")*", 2);
        return newregex;
    }

    public DependencyRegex prepend(DependencyRegex dregex) {
        DependencyRegex newregex = new DependencyRegex(this.name + "_mod", null);
        newregex.regex = this.compile(dregex.toString() + this.toString(), 2);
        return newregex;
    }

    public DependencyRegex prependOptional(DependencyRegex dregex) {
        DependencyRegex newregex = new DependencyRegex(this.name + "_mod", null);
        newregex.regex = this.compile("(" + dregex.toString() + ")*?" + this.toString(), 2);
        return newregex;
    }

    public DependencyRegex append(DEPNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, -1);
        return this.append(addregex);
    }

    public DependencyRegex appendOptional(DEPNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, -1);
        return this.appendOptional(addregex);
    }

    public DependencyRegex prepend(DEPNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, 1024);
        return this.prepend(addregex);
    }

    public DependencyRegex prependOptional(DEPNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, 1024);
        return this.prependOptional(addregex);
    }

    public DependencyRegex append(ConllDependencyNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, -1);
        return this.append(addregex);
    }

    public DependencyRegex appendOptional(ConllDependencyNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, -1);
        return this.appendOptional(addregex);
    }

    public DependencyRegex prepend(ConllDependencyNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, 1024);
        return this.prepend(addregex);
    }

    public DependencyRegex prependOptional(ConllDependencyNode[] dnodes) {
        DependencyRegex addregex = new DependencyRegex(dnodes, 1024);
        return this.prependOptional(addregex);
    }
}

