/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.data.analysis;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.cr.XMIReader;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class Utils {
    public static final String embeddingPath = "/Users/dima/Boston/Vectors/Models/ties-plus-oov.txt";

    public static CollectionReader getCollectionReader(File inputDirectory) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : inputDirectory.listFiles()) {
            if (file.isHidden()) continue;
            fileNames.add(file.getPath());
        }
        String[] paths = new String[fileNames.size()];
        fileNames.toArray(paths);
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static String getLastWord(JCas systemView, Annotation annotation) {
        List tokens = JCasUtil.selectCovered((JCas)systemView, WordToken.class, (AnnotationFS)annotation);
        if (tokens.size() == 0) {
            return annotation.getCoveredText();
        }
        WordToken lastToken = (WordToken)tokens.get(tokens.size() - 1);
        return lastToken.getCoveredText();
    }

    public static void main(String[] args) throws IOException {
        File word2vec = new File(embeddingPath);
        Map data = (Map)Files.readLines((File)word2vec, (Charset)Charsets.UTF_8, (LineProcessor)new Callback());
        System.out.println(data.get("skin"));
        System.out.println(data.get("oov"));
    }

    public static class Callback
    implements LineProcessor<Map<String, List<Double>>> {
        private Map<String, List<Double>> wordToVector = new HashMap<String, List<Double>>();

        public boolean processLine(String line) throws IOException {
            String[] elements = line.split(" ");
            ArrayList<Double> vector = new ArrayList<Double>();
            for (int dimension = 1; dimension < elements.length; ++dimension) {
                vector.add(Double.parseDouble(elements[dimension]));
            }
            this.wordToVector.put(elements[0], vector);
            return true;
        }

        public Map<String, List<Double>> getResult() {
            return this.wordToVector;
        }
    }
}

