/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.DependencyParseUtils;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class DependencyTreeFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    @Override
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(DependencyTreeFeaturesExtractor.extractForNode(jCas, arg1, "MENTION1"));
        features.addAll(DependencyTreeFeaturesExtractor.extractForNode(jCas, arg2, "MENTION2"));
        return features;
    }

    public static List<Feature> extractForNode(JCas jCas, IdentifiedAnnotation mention, String ftrPrefix) {
        ConllDependencyNode dependsOn;
        ArrayList<Feature> features = new ArrayList<Feature>();
        ConllDependencyNode mentionHeadNode = DependencyParseUtils.findAnnotationHead(jCas, (Annotation)mention);
        if (mentionHeadNode != null && (dependsOn = mentionHeadNode.getHead()) != null) {
            features.add(new Feature(ftrPrefix + "_DEPENDS_ON_WORD", (Object)dependsOn.getCoveredText()));
            features.add(new Feature(ftrPrefix + "_DEPENDS_ON_POS", (Object)dependsOn.getPostag()));
            features.add(new Feature(ftrPrefix + "_TYPE-GOVERNING_WORD", (Object)String.format("%d-%s", mention.getTypeID(), dependsOn.getCoveredText())));
            features.add(new Feature(ftrPrefix + "_HEAD_WORD-GOVERNING_WORD", (Object)String.format("%s-%s", mentionHeadNode.getCoveredText(), dependsOn.getCoveredText())));
            features.add(new Feature(ftrPrefix + "_TYPE-GOVERNING_POS", (Object)String.format("%d-%s", mention.getTypeID(), dependsOn.getPostag())));
            features.add(new Feature(ftrPrefix + "_HEAD_POS-GOVERNING_POS", (Object)String.format("%s-%s", mentionHeadNode.getPostag(), dependsOn.getPostag())));
        }
        return features;
    }
}

