/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.baselines;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.baselines.Utils;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

@PipeBitInfo(name="Location of Annotator 2", description="Annotates Location Of relations in sentences containing with multiple anatomical sites.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.LOCATION_RELATION})
public class Baseline2EntityMentionPairRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    public Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        List args = JCasUtil.selectCovered((JCas)identifiedAnnotationView, EntityMention.class, (AnnotationFS)sentence);
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        for (EntityMention arg1 : args) {
            for (EntityMention arg2 : args) {
                if (arg1.getBegin() == arg2.getBegin() && arg1.getEnd() == arg2.getEnd()) continue;
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)arg1, (IdentifiedAnnotation)arg2));
            }
        }
        int legitimateArg1Count = 0;
        int legitimateArg2Count = 0;
        for (Object entityMention : args) {
            HashSet<Integer> okArg2Types;
            if (entityMention.getTypeID() == 6) {
                ++legitimateArg1Count;
            }
            if (!(okArg2Types = new HashSet<Integer>(Arrays.asList(2, 3, 5))).contains(entityMention.getTypeID())) continue;
            ++legitimateArg2Count;
        }
        if (legitimateArg1Count < 1 || legitimateArg2Count != 1) {
            return new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        }
        HashMap<RelationExtractorAnnotator.IdentifiedAnnotationPair, Integer> distanceLookup = new HashMap<RelationExtractorAnnotator.IdentifiedAnnotationPair, Integer>();
        for (RelationExtractorAnnotator.IdentifiedAnnotationPair pair : pairs) {
            if (!Utils.validateLocationOfArgumentTypes(pair)) continue;
            try {
                int distance = Utils.getDistance(identifiedAnnotationView.getView("_InitialView"), pair);
                distanceLookup.put(pair, distance);
            }
            catch (CASException e) {
                System.out.println("couldn't get default sofa");
                break;
            }
        }
        if (distanceLookup.isEmpty()) {
            return new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        }
        ArrayList rankedPairs = new ArrayList(distanceLookup.keySet());
        Function getValue = Functions.forMap(distanceLookup);
        Collections.sort(rankedPairs, Ordering.natural().onResultOf(getValue));
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> result = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        result.add((RelationExtractorAnnotator.IdentifiedAnnotationPair)rankedPairs.get(0));
        System.out.println(sentence.getCoveredText());
        System.out.println("arg1: " + ((RelationExtractorAnnotator.IdentifiedAnnotationPair)result.get(0)).getArg1().getCoveredText());
        System.out.println("arg2: " + ((RelationExtractorAnnotator.IdentifiedAnnotationPair)result.get(0)).getArg2().getCoveredText());
        System.out.println();
        return result;
    }

    @Override
    public String classify(List<Feature> features) {
        return "location_of";
    }
}

