/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.ManagesTreatsTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Manages / Treats Annotator", description="Annotates Manages / Treats relations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.GENERIC_RELATION})
public class ManagesTreatsRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    protected Class<? extends BinaryTextRelation> getRelationClass() {
        return ManagesTreatsTextRelation.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        ArrayList arg1s = new ArrayList();
        List medications = JCasUtil.selectCovered((JCas)identifiedAnnotationView, MedicationMention.class, (AnnotationFS)sentence);
        List procedures = JCasUtil.selectCovered((JCas)identifiedAnnotationView, ProcedureMention.class, (AnnotationFS)sentence);
        arg1s.addAll(medications);
        arg1s.addAll(procedures);
        ArrayList arg2s = new ArrayList();
        List diseaseDisorders = JCasUtil.selectCovered((JCas)identifiedAnnotationView, DiseaseDisorderMention.class, (AnnotationFS)sentence);
        List signSymptoms = JCasUtil.selectCovered((JCas)identifiedAnnotationView, SignSymptomMention.class, (AnnotationFS)sentence);
        List anatomicalSites = JCasUtil.selectCovered((JCas)identifiedAnnotationView, AnatomicalSiteMention.class, (AnnotationFS)sentence);
        arg2s.addAll(diseaseDisorders);
        arg2s.addAll(signSymptoms);
        arg2s.addAll(anatomicalSites);
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        for (IdentifiedAnnotation arg1 : arg1s) {
            for (IdentifiedAnnotation arg2 : arg2s) {
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair(arg1, arg2));
            }
        }
        return pairs;
    }

    @Override
    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Argument");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Related_to");
        relArg2.addToIndexes();
        ManagesTreatsTextRelation relation = new ManagesTreatsTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    @Override
    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }
}

