/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageUtils {
    private static Log log = LogFactory.getLog(MessageUtils.class);
    private static String DETAIL_SUFFIX = "_detail";
    private static int SUMMARY = 0;
    private static int DETAIL = 1;
    private static String ICE_MESSAGES_BUNDLE = "com.icesoft.faces.resources.messages";

    public static FacesMessage getMessage(FacesContext context, String messageId) {
        return MessageUtils.getMessage(context, messageId, null);
    }

    public static FacesMessage getMessage(FacesContext facesContext, String messageId, Object[] params) {
        Locale locale;
        String[] messageInfo;
        block6: {
            messageInfo = new String[2];
            locale = facesContext.getViewRoot().getLocale();
            String bundleName = facesContext.getApplication().getMessageBundle();
            if (bundleName != null) {
                try {
                    MessageUtils.loadMessageInfo(bundleName, locale, messageId, messageInfo);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)(e + ", using " + ICE_MESSAGES_BUNDLE));
                }
            }
        }
        if (messageInfo[SUMMARY] == null && messageInfo[DETAIL] == null) {
            MessageUtils.loadMessageInfo(ICE_MESSAGES_BUNDLE, locale, messageId, messageInfo);
        }
        if (params != null) {
            for (int i = 0; i < messageInfo.length; ++i) {
                if (messageInfo[i] == null) continue;
                MessageFormat format = new MessageFormat(messageInfo[i], locale);
                messageInfo[i] = format.format(params);
            }
        }
        return new FacesMessage(messageInfo[SUMMARY], messageInfo[DETAIL]);
    }

    private static void loadMessageInfo(String bundleName, Locale locale, String messageId, String[] messageInfo) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, MessageUtils.getClassLoader(bundleName));
        try {
            messageInfo[MessageUtils.SUMMARY] = bundle.getString(messageId);
            messageInfo[MessageUtils.DETAIL] = bundle.getString(messageId + DETAIL_SUFFIX);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }

    public static ClassLoader getClassLoader(Object fallback) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = fallback.getClass().getClassLoader();
        }
        return classLoader;
    }

    public static String getResource(FacesContext facesContext, String messageId) {
        String ret = null;
        Locale locale = facesContext.getViewRoot().getLocale();
        String bundleName = facesContext.getApplication().getMessageBundle();
        if (bundleName != null) {
            ret = MessageUtils.getResource(bundleName, locale, messageId);
        }
        if (ret == null) {
            ret = MessageUtils.getResource(ICE_MESSAGES_BUNDLE, locale, messageId);
        }
        return ret;
    }

    protected static String getResource(String bundleName, Locale locale, String messageId) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, MessageUtils.getClassLoader(bundleName));
        String ret = null;
        try {
            ret = bundle.getString(messageId);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public static Object getComponentLabel(FacesContext context, UIComponent comp) {
        Object label = comp.getAttributes().get("label");
        if (MessageUtils.nullOrEmptyString(label)) {
            label = comp.getClientId(context);
        }
        return label;
    }

    private static boolean nullOrEmptyString(Object ob) {
        return ob == null || ob instanceof String && ob.toString().length() == 0;
    }
}

