/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputconnectionstatus;

import com.icesoft.faces.component.outputconnectionstatus.OutputConnectionStatus;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OutputConnectionStatusRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent uiComponent) throws IOException {
        OutputConnectionStatusRenderer.validateParameters(context, uiComponent, null);
        OutputConnectionStatus component = (OutputConnectionStatus)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext(context, uiComponent);
        if (!domContext.isInitialized()) {
            String id = uiComponent.getClientId(context);
            Element root = domContext.createRootElement("div");
            domContext.setRootNode(root);
            root.setAttribute("id", id);
            root.setAttribute("class", component.getStyleClass());
            String style = component.getStyle();
            if (style != null && style.length() > 0) {
                root.setAttribute("style", style);
            } else {
                root.removeAttribute("style");
            }
            String idleID = ClientIdPool.get(id + UINamingContainer.getSeparatorChar((FacesContext)context) + "connection-idle");
            root.appendChild(this.getNextNode(domContext, component.getInactiveClass(), component.getInactiveLabel(), idleID, true));
            String workingID = ClientIdPool.get(id + UINamingContainer.getSeparatorChar((FacesContext)context) + "connection-working");
            root.appendChild(this.getNextNode(domContext, component.getActiveClass(), component.getActiveLabel(), workingID, false));
            String troubleID = ClientIdPool.get(id + UINamingContainer.getSeparatorChar((FacesContext)context) + "connection-trouble");
            root.appendChild(this.getNextNode(domContext, component.getCautionClass(), component.getCautionLabel(), troubleID, false));
            String lostID = ClientIdPool.get(id + UINamingContainer.getSeparatorChar((FacesContext)context) + "connection-lost");
            root.appendChild(this.getNextNode(domContext, component.getDisconnectedClass(), component.getDisconnectedLabel(), lostID, false));
            Element script = domContext.createElement("script");
            script.setAttribute("type", "text/javascript");
            script.setAttribute("id", ClientIdPool.get(id + "script"));
            script.appendChild(domContext.createTextNodeUnescaped("ice.onLoad(function(){ice.ComponentIndicators('" + workingID + "', '" + idleID + "', '" + troubleID + "', '" + lostID + "', " + component.isShowPopupOnDisconnect() + ", " + component.isDisplayHourglassWhenActive() + ");});"));
            root.appendChild(script);
        }
        domContext.stepOver();
    }

    public Element getNextNode(DOMContext domContext, String classString, String label, String id, boolean visible) {
        Element div = domContext.createElement("div");
        div.setAttribute("id", id);
        div.setAttribute("class", classString);
        if (!visible) {
            div.setAttribute("style", "visibility: hidden;");
        }
        if (null == label || "".equals(label)) {
            return div;
        }
        if (label != null) {
            // empty if block
        }
        Text text = domContext.createTextNode(label);
        div.appendChild(text);
        return div;
    }
}

