/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.ctakes.assertion.util.SemanticClasses;
import org.apache.ctakes.constituency.parser.treekernel.TreeExtractor;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public class AssertionTreeUtils {
    public static final SimpleTree NULL_TREE = SimpleTree.fromString((String)"(S (TOK nullparse))");
    static HashMap<String, String> wordMap = new HashMap();
    static Random random = new Random();

    public static SimpleTree extractFeatureTree(JCas jcas, Annotation mention, SemanticClasses sems) {
        SimpleTree tree = null;
        TopTreebankNode annotationTree = AnnotationTreeUtils.getAnnotationTree((JCas)jcas, (Annotation)mention);
        if (annotationTree != null) {
            TopTreebankNode root = AnnotationTreeUtils.getTreeCopy((JCas)jcas, (TopTreebankNode)annotationTree);
            AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)mention, (String)"CONCEPT");
            tree = TreeExtractor.getSimpleClone((TreebankNode)root);
        } else {
            tree = NULL_TREE;
        }
        TreeExtractor.lowercaseWords((SimpleTree)tree);
        if (sems != null) {
            AssertionTreeUtils.replaceWordsWithSemanticClasses(tree, sems);
        }
        return tree;
    }

    public static SimpleTree extractAboveLeftConceptTree(JCas jcas, Annotation mention, SemanticClasses sems) {
        SimpleTree tree = null;
        TopTreebankNode annotationTree = AnnotationTreeUtils.getAnnotationTree((JCas)jcas, (Annotation)mention);
        if (annotationTree != null) {
            TreebankNode conceptNode;
            TopTreebankNode root = AnnotationTreeUtils.getTreeCopy((JCas)jcas, (TopTreebankNode)annotationTree);
            TreebankNode node = conceptNode = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)mention, (String)"CONCEPT");
            while (node.getParent() != null && !node.getNodeType().startsWith("S")) {
                node = node.getParent();
            }
            AnnotationTreeUtils.removeRightOfAnnotation((JCas)jcas, (TreebankNode)node, (Annotation)conceptNode);
            tree = TreeExtractor.getSimpleClone((TreebankNode)node);
        } else {
            tree = NULL_TREE;
        }
        TreeExtractor.lowercaseWords((SimpleTree)tree);
        if (sems != null) {
            AssertionTreeUtils.replaceWordsWithSemanticClasses(tree, sems);
        }
        return tree;
    }

    public static void elevateListConcepts(JCas jcas, TreebankNode tree) {
        int i;
        if (tree.getLeaf()) {
            return;
        }
        int conceptIndex = -1;
        for (i = 0; i < tree.getChildren().size(); ++i) {
            if (!tree.getChildren(i).getNodeType().equals("CONCEPT")) continue;
            conceptIndex = i;
            break;
        }
        if (conceptIndex == -1) {
            for (i = 0; i < tree.getChildren().size(); ++i) {
                AssertionTreeUtils.elevateListConcepts(jcas, tree.getChildren(i));
            }
        } else if (conceptIndex == 0 && tree.getChildren().size() > 1 && tree.getChildren(1).getNodeType().matches("CC|,") || conceptIndex == tree.getChildren().size() - 1 && tree.getChildren().size() > 1 && tree.getChildren(conceptIndex - 1).getNodeType().matches("CC|,") || conceptIndex > 0 && conceptIndex < tree.getChildren().size() - 1 && tree.getChildren().size() > 2 && tree.getChildren(conceptIndex - 1).getNodeType().equals(",") && tree.getChildren(conceptIndex + 1).getNodeType().matches("CC|,")) {
            TreebankNode entityRoot = tree.getChildren(conceptIndex).getChildren(0);
            tree.setChildren(conceptIndex, entityRoot);
            entityRoot.setParent(tree);
            TreebankNode replacementNode = new TreebankNode(jcas);
            replacementNode.setNodeType(tree.getNodeType());
            replacementNode.setChildren(tree.getChildren());
            for (int i2 = 0; i2 < replacementNode.getChildren().size(); ++i2) {
                replacementNode.getChildren(i2).setParent(replacementNode);
            }
            replacementNode.setParent(tree);
            tree.setNodeType("CONCEPT");
            FSArray children = new FSArray(jcas, 1);
            children.set(0, (FeatureStructure)replacementNode);
            tree.setChildren(children);
        }
    }

    public static SimpleTree extractAboveRightConceptTree(JCas jcas, Annotation mention, SemanticClasses sems) {
        SimpleTree tree = null;
        TopTreebankNode annotationTree = AnnotationTreeUtils.getAnnotationTree((JCas)jcas, (Annotation)mention);
        if (annotationTree != null) {
            TreebankNode conceptNode;
            TopTreebankNode root = AnnotationTreeUtils.getTreeCopy((JCas)jcas, (TopTreebankNode)annotationTree);
            TreebankNode node = conceptNode = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)mention, (String)"CONCEPT");
            while (node.getParent() != null && !node.getNodeType().startsWith("S")) {
                node = node.getParent();
            }
            AnnotationTreeUtils.removeLeftOfAnnotation((JCas)jcas, (TreebankNode)node, (Annotation)conceptNode);
            tree = TreeExtractor.getSimpleClone((TreebankNode)node);
        } else {
            tree = SimpleTree.fromString((String)"(S noparse)");
        }
        TreeExtractor.lowercaseWords((SimpleTree)tree);
        if (sems != null) {
            AssertionTreeUtils.replaceWordsWithSemanticClasses(tree, sems);
        }
        return tree;
    }

    public static void replaceWordsWithSemanticClasses(SimpleTree tree, SemanticClasses sems) {
        if (tree.isLeaf()) {
            for (Map.Entry semClass : sems.entrySet()) {
                if (!((HashSet)semClass.getValue()).contains(tree.cat)) continue;
                tree.cat = "semclass_" + (String)semClass.getKey();
            }
        } else {
            for (SimpleTree child : tree.children) {
                AssertionTreeUtils.replaceWordsWithSemanticClasses(child, sems);
            }
        }
    }

    public static void replaceDependencyWordsWithSemanticClasses(SimpleTree tree, SemanticClasses sems) {
        for (Map.Entry semClass : sems.entrySet()) {
            if (!((HashSet)semClass.getValue()).contains(tree.cat)) continue;
            tree.cat = "semclass_" + (String)semClass.getKey();
        }
        for (SimpleTree child : tree.children) {
            AssertionTreeUtils.replaceDependencyWordsWithSemanticClasses(child, sems);
        }
    }

    public void randomizeWords(SimpleTree tree, boolean dep) {
        if (!(tree.cat.equals("CONCEPT") || tree.cat.equals("TOP") || !dep && tree.children.size() != 0)) {
            if (wordMap.containsKey(tree.cat)) {
                tree.cat = wordMap.get(tree.cat);
            } else {
                String oldWord = tree.cat;
                char[] word = new char[random.nextInt(8) + 3];
                for (int j = 0; j < word.length; ++j) {
                    word[j] = (char)(97 + random.nextInt(26));
                }
                tree.cat = new String(word);
                wordMap.put(oldWord, tree.cat);
            }
        }
        if (tree.children.size() > 0) {
            for (SimpleTree child : tree.children) {
                this.randomizeWords(child, dep);
            }
        }
    }
}

