/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.train;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.assertion.util.AssertionConst;

public class PolarityCotrainingTrain {
    protected static final String SHARP_TRAIN = "/projects/data/assertion/data/preprocessed_data/sharp/train";
    protected static final String I2B2_TRAIN = "/projects/data/assertion/data/preprocessed_data/i2b2/train";
    protected static final String MIPACQ_TRAIN = "/projects/data/assertion/data/preprocessed_data/mipacq/train";
    protected static final String NEGEX_TRAIN = "/projects/data/assertion/data/preprocessed_data/negex";
    public static final String SHARP_MODEL = "../ctakes-assertion-res/resources/model/sharptrain";
    protected static final String I2B2_MODEL = "../ctakes-assertion-res/resources/model/i2b2train";
    protected static final String MIPACQ_MODEL = "../ctakes-assertion-res/resources/model/mipacqtrain";
    protected static final String NEGEX_MODEL = "../ctakes-assertion-res/resources/model/negextest";
    protected static final String SHARP_I2B2_MODEL = "../ctakes-assertion-res/resources/model/sharptrain+i2b2train";
    protected static final String SHARP_MIPACQ_MODEL = "../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain";
    protected static final String SHARP_NEGEX_MODEL = "../ctakes-assertion-res/resources/model/sharptrain+negextest";
    protected static final String I2B2_MIPACQ_NEGEX_MODEL = "../ctakes-assertion-res/resources/model/i2b2train+mipacqtrain+negextest";
    protected static final String SHARP_I2B2_MIPACQ_MODEL = "../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain";
    protected static final String SHARP_MIPACQ_NEGEX_MODEL = "../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain+negextest";
    protected static final String SHARP_I2B2_NEGEX_MODEL = "../ctakes-assertion-res/resources/model/sharptrain+i2b2train+negextest";
    protected static final String SHARP_I2B2_MIPACQ_NEGEX_MODEL = "../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex";

    public static void main(String[] args) throws Exception {
        String attribute = "polarity";
        HashMap<String, String> trainGrid = new HashMap<String, String>();
        trainGrid.put(SHARP_TRAIN, SHARP_MODEL);
        trainGrid.put(I2B2_TRAIN, I2B2_MODEL);
        trainGrid.put(MIPACQ_TRAIN, MIPACQ_MODEL);
        trainGrid.put(NEGEX_TRAIN, NEGEX_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train", SHARP_I2B2_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/mipacq/train", SHARP_MIPACQ_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/negex", SHARP_NEGEX_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/mipacq/train:/projects/data/assertion/data/preprocessed_data/negex", I2B2_MIPACQ_NEGEX_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/mipacq/train", SHARP_I2B2_MIPACQ_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/mipacq/train:/projects/data/assertion/data/preprocessed_data/negex", SHARP_MIPACQ_NEGEX_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/negex", SHARP_I2B2_NEGEX_MODEL);
        trainGrid.put("/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/mipacq/train:/projects/data/assertion/data/preprocessed_data/negex", SHARP_I2B2_MIPACQ_NEGEX_MODEL);
        for (Map.Entry oneTrain : trainGrid.entrySet()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("--train-dir");
            params.add((String)oneTrain.getKey());
            params.add("--models-dir");
            params.add((String)oneTrain.getValue());
            params.add("--train-only");
            for (String ignoreAttribute : AssertionConst.allAnnotationTypes) {
                if (ignoreAttribute.equals(attribute)) continue;
                if (ignoreAttribute.equals("historyOf")) {
                    ignoreAttribute = ignoreAttribute.substring(0, ignoreAttribute.length() - 2);
                }
                params.add("--ignore-" + ignoreAttribute);
            }
            String[] paramList = params.toArray(new String[0]);
            AssertionEvaluation.main(paramList);
        }
    }
}

