/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.pipelines;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.ctakes.assertion.cc.JudgeAttributeInstances;
import org.apache.ctakes.assertion.eval.XMIReader;
import org.apache.ctakes.assertion.util.AssertionConst;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class RunJudgeAttributeInstances {
    public static Options options = new Options();

    public static void main(String[] args) throws CmdLineException {
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        CollectionReaderDescription collectionReader = null;
        AnalysisEngineDescription userInput = null;
        try {
            TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
            List<File> items = Arrays.asList(new File(RunJudgeAttributeInstances.options.inputDir).listFiles());
            String[] paths = new String[items.size()];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = items.get(i).getAbsolutePath();
            }
            collectionReader = CollectionReaderFactory.createReaderDescription(XMIReader.class, (TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath((String[])new String[0]), (Object[])new Object[]{"files", paths});
            userInput = AnalysisEngineFactory.createEngineDescription(JudgeAttributeInstances.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"outputDirectoryName", RunJudgeAttributeInstances.options.outputDir});
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        try {
            SimplePipeline.runPipeline(collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{userInput});
        }
        catch (UIMAException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Options {
        @Option(name="--input-dir", usage="where to read the fully-annotated xmi data from", required=true)
        public String inputDir = AssertionConst.evalOutputDir;
        @Option(name="--output-dir", usage="where to write the 'adjudicated' instances in xmi format to", required=true)
        public String outputDir = AssertionConst.instanceGatheringOutputDir;
    }
}

