/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.ctakes.temporal.utils.TlinkType;

public class TlinkTypeSet
implements Iterable<TlinkType> {
    private Set<TlinkType> _tlinkTypes;
    private static final Iterator<TlinkType> EMPTY_ITERATOR = new Iterator<TlinkType>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public TlinkType next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    public boolean add(TlinkType tlinkType) {
        if (this._tlinkTypes == null) {
            this._tlinkTypes = new HashSet<TlinkType>(1);
        }
        return this._tlinkTypes.add(tlinkType);
    }

    public int size() {
        return this._tlinkTypes == null ? 0 : this._tlinkTypes.size();
    }

    public boolean isEmpty() {
        return this._tlinkTypes == null || this._tlinkTypes.isEmpty();
    }

    public boolean contains(TlinkType tlinkType) {
        return this._tlinkTypes != null && this._tlinkTypes.contains((Object)tlinkType);
    }

    public TlinkTypeSet createReciprocals() {
        TlinkTypeSet reciprocals = new TlinkTypeSet();
        for (TlinkType tlinkType : this) {
            reciprocals.add(tlinkType.getReciprocal());
        }
        return reciprocals;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "NONE,";
        }
        StringBuilder sb = new StringBuilder();
        for (TlinkType type : this._tlinkTypes) {
            sb.append(type.name()).append(" & ");
        }
        sb.setLength(sb.length() - 3);
        sb.append(",");
        return sb.toString();
    }

    @Override
    public Iterator<TlinkType> iterator() {
        if (this.isEmpty()) {
            return EMPTY_ITERATOR;
        }
        return this._tlinkTypes.iterator();
    }
}

