/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class RemoveTreeAlignedMentions
extends JCasAnnotator_ImplBase {
    public static final String PARAM_GOLDVIEW_NAME = "GOLD_VIEW_NAME";
    public static Logger logger = Logger.getLogger(RemoveTreeAlignedMentions.class);
    @ConfigurationParameter(name="GOLD_VIEW_NAME", mandatory=true, description="Name of the cas view of gold standard data")
    private String goldViewName;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection times = JCasUtil.select((JCas)jCas, TimeMention.class);
        logger.info((Object)("File contains: " + times.size() + " timex mentions from first pass."));
        ArrayList<TimeMention> removeList = new ArrayList<TimeMention>();
        for (TimeMention timeMention : times) {
            List nodes = JCasUtil.selectCovered((JCas)jCas, TreebankNode.class, (AnnotationFS)timeMention);
            boolean match = false;
            for (TreebankNode node : nodes) {
                if (node.getBegin() != timeMention.getBegin() || node.getEnd() != timeMention.getEnd()) continue;
                match = true;
                break;
            }
            if (!match) continue;
            removeList.add(timeMention);
        }
        for (Annotation annotation : removeList) {
            annotation.removeFromIndexes();
        }
        for (TimeMention timeMention : JCasUtil.select((JCas)jCas, TimeMention.class)) {
            logger.info((Object)("Preserved time mention: " + timeMention.getCoveredText()));
        }
    }
}

