/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.baselines;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;

public class RecallBaselineEventTimeRelationAnnotator
extends RelationExtractorAnnotator {
    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(RecallBaselineEventTimeRelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    protected List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation sentence) {
        List events = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence);
        List times = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence);
        if (times.size() < 1 || events.size() < 1) {
            return Lists.newArrayList();
        }
        HashMap<RelationExtractorAnnotator.IdentifiedAnnotationPair, Integer> distanceLookup = new HashMap<RelationExtractorAnnotator.IdentifiedAnnotationPair, Integer>();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            for (TimeMention time : times) {
                RelationExtractorAnnotator.IdentifiedAnnotationPair pair = new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)time, (IdentifiedAnnotation)event);
                List baseTokens = JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)pair.getArg1(), (AnnotationFS)pair.getArg2());
                int distance = baseTokens.size();
                distanceLookup.put(pair, distance);
            }
        }
        ArrayList rankedPairs = new ArrayList(distanceLookup.keySet());
        Function getValue = Functions.forMap(distanceLookup);
        Collections.sort(rankedPairs, Ordering.natural().onResultOf(getValue));
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> results = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        HashSet<EventMention> relTimes = new HashSet<EventMention>();
        for (RelationExtractorAnnotator.IdentifiedAnnotationPair result : rankedPairs) {
            if (relTimes.contains(result.getArg2())) continue;
            relTimes.add((EventMention)result.getArg2());
            results.add(result);
        }
        return results;
    }

    public String classify(List<Feature> features) {
        return "CONTAINS";
    }
}

