/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.dependency.srl.SRLEval;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.io.BufferedReader;
import java.io.IOException;
import org.kohsuke.args4j.Option;

public class SRLEvaluate
extends AbstractRun {
    @Option(name="-g", usage="the gold-standard file (input; required)", required=true, metaVar="<filename>")
    private String s_goldFile;
    @Option(name="-s", usage="the system file (input; required)", required=true, metaVar="<filename>")
    private String s_autoFile;
    @Option(name="-gi", usage="the column index of semantic arguments in the gold-standard file (input; required)", required=true, metaVar="<integer>")
    private int i_goldIndex;
    @Option(name="-si", usage="the column index of semantic arguments in the sytem file (input; required)", required=true, metaVar="<integer>")
    private int i_autoIndex;

    public SRLEvaluate() {
    }

    public SRLEvaluate(String[] args) {
        this.initArgs(args);
        this.run(this.s_goldFile, this.s_autoFile, this.i_goldIndex - 1, this.i_autoIndex - 1);
    }

    public void run(String goldFile, String autoFile, int goldIndex, int autoIndex) {
        BufferedReader fGold = UTInput.createBufferedFileReader(goldFile);
        BufferedReader fAuto = UTInput.createBufferedFileReader(autoFile);
        SRLEval eval = new SRLEval();
        try {
            String line;
            while ((line = fGold.readLine()) != null) {
                String[] gold = line.split("\t");
                String[] auto = fAuto.readLine().split("\t");
                if ((line = line.trim()).isEmpty()) continue;
                StringIntPair[] gHeads = this.toSHeads(gold[goldIndex]);
                StringIntPair[] aHeads = this.toSHeads(auto[autoIndex]);
                eval.evaluate(gHeads, aHeads);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        eval.print();
    }

    private StringIntPair[] toSHeads(String sHeads) {
        if (sHeads.equals("_")) {
            return new StringIntPair[0];
        }
        String[] heads = sHeads.split(";");
        int size = heads.length;
        StringIntPair[] p = new StringIntPair[size];
        for (int i = 0; i < size; ++i) {
            String[] tmp = heads[i].split(":");
            int headId = Integer.parseInt(tmp[0]);
            String label = tmp[1];
            p[i] = new StringIntPair(label, headId);
        }
        return p;
    }

    public static void main(String[] args) {
        new SRLEvaluate(args);
    }
}

