/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.PrintStream;
import java.util.Arrays;

public class SRLExpand {
    public SRLExpand(String inputFile, String outputFile) {
        DEPTree tree;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        SRLReader reader = new SRLReader(0, 1, 2, 3, 4, 5, 6, 7);
        reader.open(UTInput.createBufferedFileReader(inputFile));
        while ((tree = reader.next()) != null) {
            tree.setDependents();
            this.printSpans(fout, tree);
        }
        reader.close();
        fout.close();
    }

    private void printSpans(PrintStream fout, DEPTree tree) {
        String[][] spans = this.expandSRL(tree);
        if (spans == null) {
            fout.println(tree + "\n");
            return;
        }
        StringBuilder build = new StringBuilder();
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            build.append(node.toStringDEP());
            build.append("\t");
            build.append(UTArray.join(spans[i], "\t"));
            build.append("\n");
        }
        fout.println(build.toString());
    }

    public String[][] expandSRL(DEPTree tree) {
        DEPNode pred;
        ObjectIntOpenHashMap map = new ObjectIntOpenHashMap();
        int i = 0;
        int predId = 0;
        int size = tree.size();
        while ((pred = tree.getNextPredicate(predId)) != null) {
            map.put((Object)pred, i++);
            predId = pred.id;
        }
        if (map.isEmpty()) {
            return null;
        }
        String[][] spans = new String[size][];
        int len = map.size();
        for (i = 1; i < size; ++i) {
            spans[i] = new String[len];
            Arrays.fill(spans[i], "_");
        }
        for (i = 1; i < size; ++i) {
            DEPNode arg = tree.get(i);
            for (DEPArc arc : arg.getSHeads()) {
                pred = arc.getNode();
                if (!map.containsKey((Object)pred)) continue;
                predId = map.get((Object)pred);
                String label = arc.getLabel();
                for (int spanId : this.getSpan(pred, arg)) {
                    spans[spanId][predId] = label;
                }
            }
        }
        return spans;
    }

    private int[] getSpan(DEPNode pred, DEPNode arg) {
        IntOpenHashSet sArg = arg.getSubtreeIdSet();
        if (pred.isDescendentOf(arg)) {
            sArg.removeAll((IntLookupContainer)pred.getSubtreeIdSet());
        }
        int[] span = sArg.toArray();
        return span;
    }

    public static void main(String[] args) {
        new SRLExpand(args[0], args[1]);
    }
}

