/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.coreference.Mention;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.JointReader;
import com.googlecode.clearnlp.util.UTInput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CheckMentions {
    public CheckMentions(String inDir) {
        JointReader reader = new JointReader(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        File file = new File(inDir);
        for (String filename : file.list()) {
            DEPTree tree;
            if (!filename.endsWith("c")) continue;
            reader.open(UTInput.createBufferedFileReader(inDir + File.separator + filename));
            System.out.println(filename);
            while ((tree = reader.next()) != null) {
                tree.setDependents();
                this.check(tree);
            }
            reader.close();
        }
    }

    public void check(DEPTree tree) {
        List<Mention> mentions = tree.getMentions();
        for (Mention m : mentions) {
            List<DEPNode> heads = this.getHeads(tree, m.beginIndex, m.endIndex);
            if (heads.size() <= 1) continue;
            System.out.println(m.beginIndex + " " + m.endIndex + "\n" + tree.toStringDEP() + "\n");
        }
    }

    private List<DEPNode> getHeads(DEPTree tree, int bIdx, int eIdx) {
        ArrayList<DEPNode> heads = new ArrayList<DEPNode>();
        for (int i = bIdx; i <= eIdx; ++i) {
            DEPNode node = tree.get(i);
            int headId = node.getHead().id;
            if (headId >= bIdx && headId <= eIdx) continue;
            heads.add(node);
        }
        return heads;
    }

    public static void main(String[] args) {
        new CheckMentions(args[0]);
    }
}

