/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.concept;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.concept.ConceptFactory;
import org.apache.ctakes.dictionary.lookup2.concept.DefaultConcept;
import org.apache.ctakes.dictionary.lookup2.concept.MemConceptFactory;
import org.apache.ctakes.dictionary.lookup2.util.CuiCodeUtil;
import org.apache.ctakes.dictionary.lookup2.util.LookupUtil;
import org.apache.ctakes.dictionary.lookup2.util.TuiCodeUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public final class BsvConceptFactory
implements ConceptFactory {
    private static final Logger LOGGER = Logger.getLogger((String)"BsvConceptFactory");
    private static final String BSV_FILE_PATH = "bsvPath";
    private final ConceptFactory _delegateFactory;

    public BsvConceptFactory(String name, UimaContext uimaContext, Properties properties) {
        this(name, properties.getProperty(BSV_FILE_PATH));
    }

    public BsvConceptFactory(String name, String bsvFilePath) {
        Collection<CuiTuiTerm> cuiTuiTerms = BsvConceptFactory.parseBsvFile(bsvFilePath);
        HashMap<Long, Concept> conceptMap = new HashMap<Long, Concept>(cuiTuiTerms.size());
        for (CuiTuiTerm cuiTuiTerm : cuiTuiTerms) {
            HashSetMap codes = new HashSetMap();
            codes.placeValue((Object)"TUI", (Object)TuiCodeUtil.getAsTui(cuiTuiTerm.getTui()));
            conceptMap.put(CuiCodeUtil.getInstance().getCuiCode(cuiTuiTerm.getCui()), new DefaultConcept(cuiTuiTerm.getCui(), cuiTuiTerm.getPrefTerm(), (CollectionMap<String, String, ? extends Collection<String>>)codes));
        }
        this._delegateFactory = new MemConceptFactory(name, conceptMap);
    }

    @Override
    public String getName() {
        return this._delegateFactory.getName();
    }

    @Override
    public Concept createConcept(Long cuiCode) {
        return this._delegateFactory.createConcept(cuiCode);
    }

    @Override
    public Map<Long, Concept> createConcepts(Collection<Long> cuiCodes) {
        return this._delegateFactory.createConcepts(cuiCodes);
    }

    private static Collection<CuiTuiTerm> parseBsvFile(String bsvFilePath) {
        ArrayList<CuiTuiTerm> cuiTuiTerms = new ArrayList<CuiTuiTerm>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileLocator.getAsStream((String)bsvFilePath)));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("//") || line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                String[] columns = LookupUtil.fastSplit(line, '|');
                CuiTuiTerm cuiTuiTerm = BsvConceptFactory.createCuiTuiTerm(columns);
                if (cuiTuiTerm != null) {
                    cuiTuiTerms.add(cuiTuiTerm);
                } else {
                    LOGGER.warn((Object)("Bad BSV line " + line + " in " + bsvFilePath));
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
        }
        return cuiTuiTerms;
    }

    private static CuiTuiTerm createCuiTuiTerm(String ... columns) {
        if (columns.length < 2) {
            return null;
        }
        boolean cuiIndex = false;
        boolean tuiIndex = true;
        int termIndex = -1;
        if (columns.length >= 4) {
            termIndex = 3;
        }
        if (columns[0].trim().isEmpty() || columns[1].trim().isEmpty()) {
            return null;
        }
        String cui = columns[0];
        String tui = columns[1].trim().isEmpty() ? "T000" : columns[1].trim();
        String preferredTerm = termIndex < 0 || columns[termIndex].trim().isEmpty() ? "" : columns[termIndex].trim();
        return new CuiTuiTerm(cui, tui, preferredTerm);
    }

    public static class CuiTuiTerm {
        private final String __cui;
        private final String __tui;
        private final String __prefTerm;
        private final int __hashcode;

        public CuiTuiTerm(String cui, String tui, String preferredTerm) {
            this.__cui = cui;
            this.__tui = tui;
            this.__prefTerm = preferredTerm;
            this.__hashcode = (this.__cui + "_" + this.__tui + "_" + this.__prefTerm).hashCode();
        }

        public String getCui() {
            return this.__cui;
        }

        public String getTui() {
            return this.__tui;
        }

        public String getPrefTerm() {
            return this.__prefTerm;
        }

        public boolean equals(Object value) {
            return value instanceof CuiTuiTerm && this.__prefTerm.equals(((CuiTuiTerm)value).__prefTerm) && this.__tui.equals(((CuiTuiTerm)value).__tui) && this.__cui.equals(((CuiTuiTerm)value).__cui);
        }

        public int hashCode() {
            return this.__hashcode;
        }
    }
}

