/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.sliderentry;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import org.icefaces.component.sliderentry.SliderEntry;
import org.icefaces.component.utils.JSONBuilder;
import org.icefaces.component.utils.ScriptWriter;
import org.icefaces.component.utils.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(value="org.icefaces.component.sliderentry.SliderEntry")
public class SliderEntryRenderer
extends Renderer {
    List<UIParameter> uiParamChildren;
    private static final Logger log = Logger.getLogger(SliderEntryRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        SliderEntry slider = (SliderEntry)uiComponent;
        boolean foundInMap = false;
        if (requestParameterMap.containsKey(clientId + "_hidden") && !slider.isSingleSubmit()) {
            foundInMap = true;
        }
        if (requestParameterMap.containsKey("ice.event.captured") || foundInMap) {
            String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
            if ("ice.ser".equals(requestParameterMap.get("ice.submit.type"))) {
                facesContext.renderResponse();
                return;
            }
            Object hiddenValue = requestParameterMap.get(clientId + "_hidden");
            if (hiddenValue == null) {
                return;
            }
            int submittedValue = 0;
            try {
                submittedValue = Integer.valueOf(hiddenValue.toString());
                log.finer("Decoded slider value [id:value] [" + clientId + ":" + hiddenValue + "]");
            }
            catch (NumberFormatException nfe) {
                log.warning("NumberFormatException  Decoding value for [id:value] [" + clientId + ":" + hiddenValue + "]");
            }
            catch (NullPointerException npe) {
                log.warning("NullPointerException  Decoding value for [id:value] [" + clientId + ":" + hiddenValue + "]");
            }
            if (clientId.equals(source) || foundInMap) {
                try {
                    int value = slider.getValue();
                    if (value != submittedValue) {
                        uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, (Object)new Integer(value), (Object)new Integer(submittedValue)));
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String style;
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        SliderEntry slider = (SliderEntry)uiComponent;
        this.uiParamChildren = Utils.captureParameters((UIComponent)slider);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_div"), "id");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        String styleClass = slider.getStyleClass();
        if (styleClass != null && styleClass.trim().length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        if ((style = slider.getStyle()) != null && style.trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.endElement("div");
        int value = slider.getValue();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
        StringBuilder sb = new StringBuilder();
        sb.append(styleClass).append(style).append(slider.isShowLabels());
        JSONBuilder jsBuilder = JSONBuilder.create().beginMap().entry("min", slider.getMin()).entry("max", slider.getMax()).entry("value", value).entry("axis", slider.getAxis()).entry("length", slider.getLength()).entry("clickableRail", slider.isClickableRail()).entry("disabled", slider.isDisabled());
        String thumbUrl = slider.getThumbUrl();
        if (thumbUrl != null && thumbUrl.trim().length() > 0) {
            jsBuilder.entry("thumbUrl", thumbUrl);
        }
        boolean ariaEnabled = EnvUtils.isAriaEnabled((FacesContext)facesContext);
        Integer tabindex = slider.getTabindex();
        if (ariaEnabled && tabindex == null) {
            tabindex = 0;
        }
        JSONBuilder jb = JSONBuilder.create().beginMap().entry("singleSubmit", slider.isSingleSubmit()).entry("aria", ariaEnabled).entry("hashCode", sb.toString().hashCode()).entry("stepPercent", slider.getStepPercent()).entry("showLabels", slider.isShowLabels());
        if (tabindex != null) {
            jb.entry("tabindex", tabindex);
        }
        if (thumbUrl != null && thumbUrl.trim().length() > 0) {
            jb.entry("thumbUrl", thumbUrl);
        }
        if (this.uiParamChildren != null) {
            jb.entry("postParameters", Utils.asStringArray(this.uiParamChildren));
        }
        String jsProps = jsBuilder.endMap().toString();
        String jsfProps = jb.endMap().toString();
        String params = "'" + clientId + "'," + jsProps + "," + jsfProps;
        String finalScript = "ice.component.slider.updateProperties(" + params + ");";
        log.finer("slider script contents: " + finalScript);
        ScriptWriter.insertScript(facesContext, uiComponent, finalScript);
        writer.endElement("div");
    }
}

