/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.resource;

import java.io.File;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.resource.LuceneIndexReaderResource;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.RAMDirectory;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;

public class LuceneIndexReaderResourceImpl
implements LuceneIndexReaderResource,
SharedResourceObject {
    private Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    private IndexReader iv_indexReader;

    public void load(DataResource dr) throws ResourceInitializationException {
        ConfigurationParameterSettings cps = dr.getMetaData().getConfigurationParameterSettings();
        Boolean useMemoryIndex = (Boolean)cps.getParameterValue("UseMemoryIndex");
        String indexDirStr = (String)cps.getParameterValue("IndexDirectory");
        try {
            File indexDir = FileLocator.locateFile(indexDirStr);
            if (!indexDir.exists()) {
                this.iv_logger.info((Object)("indexDir=" + indexDirStr + "  does not exist!"));
            } else {
                this.iv_logger.info((Object)("indexDir=" + indexDirStr + "  exists."));
            }
            if (useMemoryIndex.booleanValue()) {
                this.iv_logger.info((Object)("Loading Lucene Index into memory: " + indexDir));
                FSDirectory fsd = FSDirectory.open((File)indexDir);
                RAMDirectory d = new RAMDirectory((Directory)fsd, IOContext.DEFAULT);
                this.iv_indexReader = IndexReader.open((Directory)d);
            } else {
                this.iv_logger.info((Object)("Loading Lucene Index: " + indexDir));
                FSDirectory fsd = FSDirectory.open((File)indexDir);
                this.iv_indexReader = IndexReader.open((Directory)fsd);
            }
            this.iv_logger.info((Object)("Loaded Lucene Index, # docs=" + this.iv_indexReader.numDocs()));
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    @Override
    public IndexReader getIndexReader() {
        return this.iv_indexReader;
    }
}

