/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CasInitializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

@PipeBitInfo(name="Text Files Reader", description="Reads document texts from text files specified in a provided list.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class TextReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_FILES = "files";
    @ConfigurationParameter(name="files", mandatory=true, description="The text files to be loaded")
    private List<File> files;
    private Iterator<File> filesIter;
    private int completed;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.filesIter = this.files.iterator();
        this.completed = 0;
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.completed, this.files.size(), "entities")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.filesIter.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNext(JCas jCas) throws IOException, CollectionException {
        File currentFile = this.filesIter.next();
        String filename = currentFile.getName();
        FileInputStream fileInputStream = new FileInputStream(currentFile);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        CasInitializer casInitializer = this.getCasInitializer();
        if (casInitializer != null) {
            casInitializer.initializeCas((Object)bufferedReader, jCas.getCas());
        } else {
            try {
                byte[] contents = new byte[(int)currentFile.length()];
                fileInputStream.read(contents);
                String text = new String(contents);
                jCas.setDocumentText(text);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        DocumentID documentIDAnnotation = new DocumentID(jCas);
        documentIDAnnotation.setDocumentID(filename);
        documentIDAnnotation.addToIndexes();
        ++this.completed;
    }
}

