/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.model.TreeKernelSvmModel;

@Beta
public class TreeKernelSvmBooleanOutcomeClassifier
extends Classifier_ImplBase<TreeFeatureVector, Boolean, Boolean> {
    TreeKernelSvmModel model = null;

    public TreeKernelSvmBooleanOutcomeClassifier(FeaturesEncoder<TreeFeatureVector> featuresEncoder, OutcomeEncoder<Boolean, Boolean> outcomeEncoder, TreeKernelSvmModel model) {
        super(featuresEncoder, outcomeEncoder);
        this.model = model;
    }

    public Boolean classify(List<Feature> features) throws CleartkProcessingException {
        return this.predict(features) > 0.0;
    }

    public Map<Boolean, Double> score(List<Feature> features) throws CleartkProcessingException {
        double prediction = this.predict(features);
        HashMap scores = Maps.newHashMap();
        scores.put(true, prediction);
        scores.put(false, 1.0 - prediction);
        return scores;
    }

    private double predict(List<Feature> features) throws CleartkProcessingException {
        TreeFeatureVector featureVector = (TreeFeatureVector)this.featuresEncoder.encodeAll(features);
        return this.model.evaluate(featureVector);
    }
}

