/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.smokingstatus.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.DisjoinCondition;
import org.apache.ctakes.core.fsm.condition.NegateCondition;
import org.apache.ctakes.core.fsm.condition.TextSetCondition;
import org.apache.ctakes.core.fsm.output.NegationIndicator;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.state.NonTerminalEndState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class NegationFSM {
    private Set<String> iv_modalVerbsSet = new HashSet<String>();
    private Set<String> iv_negParticlesSet = new HashSet<String>();
    private Set<String> iv_regVerbsSet = new HashSet<String>();
    private Set<String> iv_negVerbsSet = new HashSet<String>();
    private Set<String> iv_negPrepositionsSet = new HashSet<String>();
    private Set<String> iv_negDeterminersSet = new HashSet<String>();
    private Set<String> iv_regNounsSet = new HashSet<String>();
    private Set<String> iv_regPrepositionsSet = new HashSet<String>();
    private Set<String> iv_negAdjectivesSet = new HashSet<String>();
    private Set<String> iv_negCollocSet = new HashSet<String>();
    private Set<String> iv_negColPartSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public NegationFSM() {
        this.iv_modalVerbsSet.add("can");
        this.iv_modalVerbsSet.add("ca");
        this.iv_modalVerbsSet.add("will");
        this.iv_modalVerbsSet.add("must");
        this.iv_modalVerbsSet.add("could");
        this.iv_modalVerbsSet.add("would");
        this.iv_modalVerbsSet.add("should");
        this.iv_modalVerbsSet.add("shall");
        this.iv_modalVerbsSet.add("did");
        this.iv_negParticlesSet.add("not");
        this.iv_negColPartSet.add("out");
        this.iv_negParticlesSet.add("n't");
        this.iv_negParticlesSet.add("'t");
        this.iv_negCollocSet.add("rule");
        this.iv_negCollocSet.add("rules");
        this.iv_negCollocSet.add("ruled");
        this.iv_negCollocSet.add("ruling");
        this.iv_negCollocSet.add("rule-out");
        this.iv_regVerbsSet.add("reveal");
        this.iv_regVerbsSet.add("reveals");
        this.iv_regVerbsSet.add("revealed");
        this.iv_regVerbsSet.add("revealing");
        this.iv_regVerbsSet.add("have");
        this.iv_regVerbsSet.add("had");
        this.iv_regVerbsSet.add("has");
        this.iv_regVerbsSet.add("feel");
        this.iv_regVerbsSet.add("feels");
        this.iv_regVerbsSet.add("felt");
        this.iv_regVerbsSet.add("feeling");
        this.iv_regVerbsSet.add("complain");
        this.iv_regVerbsSet.add("complains");
        this.iv_regVerbsSet.add("complained");
        this.iv_regVerbsSet.add("complaining");
        this.iv_regVerbsSet.add("demonstrate");
        this.iv_regVerbsSet.add("demonstrates");
        this.iv_regVerbsSet.add("demonstrated");
        this.iv_regVerbsSet.add("demonstrating");
        this.iv_regVerbsSet.add("appear");
        this.iv_regVerbsSet.add("appears");
        this.iv_regVerbsSet.add("appeared");
        this.iv_regVerbsSet.add("appearing");
        this.iv_regVerbsSet.add("caused");
        this.iv_regVerbsSet.add("cause");
        this.iv_regVerbsSet.add("causing");
        this.iv_regVerbsSet.add("causes");
        this.iv_regVerbsSet.add("find");
        this.iv_regVerbsSet.add("finds");
        this.iv_regVerbsSet.add("found");
        this.iv_regVerbsSet.add("discover");
        this.iv_regVerbsSet.add("discovered");
        this.iv_regVerbsSet.add("discovers");
        this.iv_negVerbsSet.add("deny");
        this.iv_negVerbsSet.add("denies");
        this.iv_negVerbsSet.add("denied");
        this.iv_negVerbsSet.add("denying");
        this.iv_negVerbsSet.add("fail");
        this.iv_negVerbsSet.add("fails");
        this.iv_negVerbsSet.add("failed");
        this.iv_negVerbsSet.add("failing");
        this.iv_negVerbsSet.add("decline");
        this.iv_negVerbsSet.add("declines");
        this.iv_negVerbsSet.add("declined");
        this.iv_negVerbsSet.add("declining");
        this.iv_negVerbsSet.add("exclude");
        this.iv_negVerbsSet.add("excludes");
        this.iv_negVerbsSet.add("excluding");
        this.iv_negVerbsSet.add("excluded");
        this.iv_negPrepositionsSet.add("without");
        this.iv_negPrepositionsSet.add("absent");
        this.iv_negPrepositionsSet.add("none");
        this.iv_negPrepositionsSet.add("non");
        this.iv_negDeterminersSet.add("no");
        this.iv_negDeterminersSet.add("any");
        this.iv_negDeterminersSet.add("neither");
        this.iv_negDeterminersSet.add("nor");
        this.iv_negDeterminersSet.add("never");
        this.iv_negDeterminersSet.add("non-contributory");
        this.iv_negDeterminersSet.add("noncontributory");
        this.iv_negDeterminersSet.add("non");
        this.iv_regNounsSet.add("evidence");
        this.iv_regNounsSet.add("indication");
        this.iv_regNounsSet.add("indications");
        this.iv_regNounsSet.add("sign");
        this.iv_regNounsSet.add("signs");
        this.iv_regNounsSet.add("symptoms");
        this.iv_regNounsSet.add("symptom");
        this.iv_regNounsSet.add("sx");
        this.iv_regNounsSet.add("dx");
        this.iv_regNounsSet.add("diagnosis");
        this.iv_regNounsSet.add("history");
        this.iv_regNounsSet.add("hx");
        this.iv_regNounsSet.add("findings");
        this.iv_regPrepositionsSet.add("of");
        this.iv_regPrepositionsSet.add("in");
        this.iv_regPrepositionsSet.add("for");
        this.iv_regPrepositionsSet.add("with");
        this.iv_negAdjectivesSet.add("unremarkable");
        this.iv_negAdjectivesSet.add("unlikely");
        this.iv_negAdjectivesSet.add("negative");
        this.iv_machineSet.add(this.getAspectualNegIndicatorMachine());
        this.iv_machineSet.add(this.getNominalNegIndicatorMachine());
        this.iv_machineSet.add(this.getAdjNegIndicatorMachine());
    }

    private Machine getAspectualNegIndicatorMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState anyState = new NamedState("ANY");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState regModalState = new NamedState("REG_MODAL");
        NamedState negPartState = new NamedState("NEG_PART");
        NamedState negVerbState = new NamedState("NEG_VERB");
        NamedState negCollocState = new NamedState("NEG_COLLOC");
        NamedState negColPartState = new NamedState("NEG_COLPART");
        TextSetCondition regModalC = new TextSetCondition(this.iv_modalVerbsSet, false);
        TextSetCondition negPartC = new TextSetCondition(this.iv_negParticlesSet, false);
        TextSetCondition regVerbC = new TextSetCondition(this.iv_regVerbsSet, false);
        TextSetCondition negVerbC = new TextSetCondition(this.iv_negVerbsSet, false);
        TextSetCondition negDetC = new TextSetCondition(this.iv_negDeterminersSet, false);
        TextSetCondition negCollocC = new TextSetCondition(this.iv_negCollocSet, false);
        TextSetCondition negColPartC = new TextSetCondition(this.iv_negColPartSet, false);
        NegateCondition notCollocC = new NegateCondition((Condition)negCollocC);
        startState.addTransition((Condition)negVerbC, (State)negVerbState);
        startState.addTransition((Condition)negCollocC, (State)negCollocState);
        startState.addTransition((Condition)new DisjoinCondition((Condition)regModalC, (Condition)regVerbC), (State)regModalState);
        startState.addTransition((Condition)new DisjoinCondition((Condition)negPartC, (Condition)negDetC), (State)negPartState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        regModalState.addTransition((Condition)negCollocC, (State)negCollocState);
        negCollocState.addTransition((Condition)negColPartC, (State)negColPartState);
        negColPartState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        negCollocState.addTransition((Condition)new AnyCondition(), (State)startState);
        regModalState.addTransition((Condition)new DisjoinCondition((Condition)negPartC, (Condition)negDetC), (State)negPartState);
        regModalState.addTransition((Condition)new AnyCondition(), (State)anyState);
        anyState.addTransition((Condition)new DisjoinCondition((Condition)negPartC, (Condition)negDetC), (State)negPartState);
        anyState.addTransition((Condition)new AnyCondition(), (State)startState);
        negPartState.addTransition((Condition)notCollocC, (State)ntEndState);
        negVerbState.addTransition((Condition)notCollocC, (State)ntEndState);
        negPartState.addTransition((Condition)new AnyCondition(), (State)startState);
        negVerbState.addTransition((Condition)new AnyCondition(), (State)startState);
        negPartState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        negVerbState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        ntEndState.addTransition((Condition)new AnyCondition(), (State)endState);
        return m;
    }

    private Machine getNominalNegIndicatorMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState anyState = new NamedState("ANY");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState negPrepState = new NamedState("NEG_PREP");
        NamedState negDetState = new NamedState("NEG_DET");
        NamedState regNounState = new NamedState("REG_NOUN");
        TextSetCondition negPrepC = new TextSetCondition(this.iv_negPrepositionsSet, false);
        TextSetCondition negDetC = new TextSetCondition(this.iv_negDeterminersSet, false);
        TextSetCondition regNounC = new TextSetCondition(this.iv_regNounsSet, false);
        startState.addTransition((Condition)negDetC, (State)negDetState);
        startState.addTransition((Condition)negPrepC, (State)negPrepState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        negPrepState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        negDetState.addTransition((Condition)regNounC, (State)regNounState);
        negDetState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        negDetState.addTransition((Condition)new AnyCondition(), (State)anyState);
        anyState.addTransition((Condition)regNounC, (State)regNounState);
        anyState.addTransition((Condition)new AnyCondition(), (State)anyState);
        regNounState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        ntEndState.addTransition((Condition)new AnyCondition(), (State)endState);
        return m;
    }

    private Machine getAdjNegIndicatorMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState regPrepState = new NamedState("REG_PREP");
        NamedState negAdjState = new NamedState("NEG_ADJ");
        TextSetCondition regPrepC = new TextSetCondition(this.iv_regPrepositionsSet, false);
        TextSetCondition negAdjC = new TextSetCondition(this.iv_negAdjectivesSet, false);
        startState.addTransition((Condition)negAdjC, (State)negAdjState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        negAdjState.addTransition((Condition)regPrepC, (State)regPrepState);
        regPrepState.addTransition((Condition)new AnyCondition(), (State)ntEndState);
        negAdjState.addTransition((Condition)new AnyCondition(), (State)startState);
        ntEndState.addTransition((Condition)new AnyCondition(), (State)endState);
        return m;
    }

    public Set<NegationIndicator> execute(List<?> tokens) throws Exception {
        HashSet<NegationIndicator> outSet = new HashSet<NegationIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? (BaseToken)tokens.get(i - 1) : token;
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                NegationIndicator neg = new NegationIndicator(startToken.getStartOffset(), endToken.getEndOffset());
                outSet.add(neg);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return outSet;
    }
}

