/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.smokingstatus.ae;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.smokingstatus.type.libsvm.NominalAttributeValue;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;

public class PcsClassifierAnnotator_libsvm
extends JCasAnnotator_ImplBase {
    Set<String> stopWords;
    List<String> goWords;
    boolean caseSensitive = true;
    Map<?, ?> tokenCounts;
    svm_model model;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.tokenCounts = new HashMap();
        this.stopWords = new HashSet<String>();
        this.goWords = new ArrayList<String>();
        try {
            Object paramValue = aContext.getConfigParameterValue("CaseSensitive");
            if (paramValue != null) {
                this.caseSensitive = (Boolean)paramValue;
            }
            FileResource stopWordsFileName = (FileResource)aContext.getResourceObject("StopWordsFile");
            this.stopWords = this.readLinesFromFile(stopWordsFileName.getFile().getAbsolutePath());
            FileResource pcsKeyWordFile = (FileResource)aContext.getResourceObject("PCSKeyWordFile");
            this.goWords = this.readOrderedLinesFromFile(pcsKeyWordFile.getFile().getAbsolutePath());
            FileResource pathOfTrainedModel = (FileResource)aContext.getResourceObject("PathOfModel");
            this.model = svm.svm_load_model((String)pathOfTrainedModel.getFile().getAbsolutePath());
        }
        catch (Exception ace) {
            ace.printStackTrace();
        }
    }

    public void process(JCas jcas) {
        ArrayList<Double> feature = new ArrayList<Double>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator wordTokenItr = indexes.getAnnotationIndex(WordToken.type).iterator();
        ArrayList<String> unigrams = new ArrayList<String>();
        ArrayList<String> bigrams = new ArrayList<String>();
        while (wordTokenItr.hasNext()) {
            WordToken token = (WordToken)((Object)wordTokenItr.next());
            String tok = token.getCoveredText();
            if (tok == null) continue;
            if (!this.caseSensitive) {
                tok = tok.toLowerCase();
            }
            tok = tok.toLowerCase().replaceAll("-{2,}", " ").trim();
            String[] toks = tok.split("\\s");
            for (int i = 0; i < toks.length; ++i) {
                if (this.stopWords.contains(toks[i])) continue;
                unigrams.add(toks[i]);
            }
        }
        for (int i = 0; i < unigrams.size() - 1; ++i) {
            bigrams.add((String)unigrams.get(i) + "_" + (String)unigrams.get(i + 1));
        }
        for (String k : this.goWords) {
            int i;
            double val = 0.0;
            if (k.indexOf("_") != -1) {
                for (i = 0; i < bigrams.size(); ++i) {
                    if (!k.equalsIgnoreCase((String)bigrams.get(i))) continue;
                    val = 1.0;
                    break;
                }
            } else {
                for (i = 0; i < unigrams.size(); ++i) {
                    if (!k.equalsIgnoreCase((String)unigrams.get(i))) continue;
                    val = 1.0;
                    break;
                }
            }
            feature.add(new Double(val));
        }
        double dateInfo = 0.0;
        String sen = jcas.getDocumentText();
        sen = sen.replaceAll("[.?!:;()',\"{}<>#+]", " ").trim();
        String[] strTokens = sen.split("\\s");
        for (int i = 0; i < strTokens.length; ++i) {
            String s = strTokens[i];
            if (!s.matches("19\\d\\d") && !s.matches("19\\d\\ds") && !s.matches("20\\d\\d") && !s.matches("20\\d\\ds") && !s.matches("[1-9]0s") && !s.matches("\\d{1,2}[/-]\\d{1,2}") && !s.matches("\\d{1,2}[/-]\\d{4}") && !s.matches("\\d{1,2}[/-]\\d{1,2}[/-]\\d{2}") && !s.matches("\\d{1,2}[/-]\\d{1,2}[/-]\\d{4}")) continue;
            dateInfo = 1.0;
            break;
        }
        feature.add(new Double(dateInfo));
        svm_node[] x = new svm_node[feature.size()];
        for (int j = 0; j < feature.size(); ++j) {
            x[j] = new svm_node();
            x[j].index = j + 1;
            x[j].value = (Double)feature.get(j);
        }
        double clsLabel = svm.svm_predict((svm_model)this.model, (svm_node[])x);
        String clsVal = clsLabel == 1.0 ? "CURRENT_SMOKER" : (clsLabel == 2.0 ? "PAST_SMOKER" : (clsLabel == 3.0 ? "SMOKER" : null));
        NominalAttributeValue nominalAttributeValue = new NominalAttributeValue(jcas);
        nominalAttributeValue.setAttributeName("smoking_status");
        nominalAttributeValue.setNominalValue(clsVal);
        nominalAttributeValue.addToIndexes();
    }

    private Set<String> readLinesFromFile(String fileName) throws IOException {
        String line;
        HashSet<String> returnValues = new HashSet<String>();
        File file = new File(fileName);
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            if (!this.caseSensitive) {
                line = line.toLowerCase();
            }
            returnValues.add(line);
        }
        return returnValues;
    }

    private List<String> readOrderedLinesFromFile(String fileName) throws IOException {
        String line;
        ArrayList<String> returnValues = new ArrayList<String>();
        File file = new File(fileName);
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            if (line.length() == 0) continue;
            if (!this.caseSensitive) {
                line = line.toLowerCase();
            }
            returnValues.add(line);
        }
        return returnValues;
    }
}

