/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.web.search;

import java.io.Serializable;
import java.util.Properties;
import javax.faces.context.FacesContext;
import javax.sql.DataSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class DocumentViewBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient DataSource dataSource;
    private String docText;
    private int documentID;
    private transient SimpleJdbcTemplate jdbcTemplate;
    private String rawText;
    private Properties searchProperties;
    private Properties ytexProperties;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getDocText() {
        this.loadDocument();
        return this.docText;
    }

    public int getDocumentID() {
        String strDocumentID = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("documentID");
        if (strDocumentID != null) {
            try {
                this.documentID = Integer.parseInt(strDocumentID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.documentID;
    }

    private String getQuery() {
        return this.searchProperties.getProperty("retrieveDocumentByID").replaceAll("@db\\.schema@", this.getYtexProperties().getProperty("db.schema"));
    }

    public String getRawText() {
        return this.rawText;
    }

    public Properties getSearchProperties() {
        return this.searchProperties;
    }

    public Properties getYtexProperties() {
        return this.ytexProperties;
    }

    public void loadDocument() {
        if (this.getDocumentID() != 0) {
            this.rawText = this.loadRawText(this.documentID);
            if (this.rawText != null) {
                this.docText = StringEscapeUtils.escapeXml((String)this.rawText).replaceAll("\n", "<br>");
            }
        }
    }

    private String loadRawText(int documentId) {
        return (String)this.jdbcTemplate.queryForObject(this.getQuery(), String.class, new Object[]{documentId});
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setSearchProperties(Properties searchProperties) {
        this.searchProperties = searchProperties;
    }

    public void setYtexProperties(Properties ytexProperties) {
        this.ytexProperties = ytexProperties;
    }
}

