/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.util.CharSequenceLexer;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class Csv2Array
extends Pipe {
    CharSequenceLexer lexer;
    int numberFeatures = -1;
    private static Logger logger = MalletLogger.getLogger(Csv2Array.class.getName());

    public Csv2Array() {
        this.lexer = new CharSequenceLexer("([^,]+)");
    }

    public Csv2Array(String regex) {
        this.lexer = new CharSequenceLexer(regex);
    }

    public Csv2Array(CharSequenceLexer l) {
        this.lexer = l;
    }

    @Override
    public Instance pipe(Instance carrier) {
        CharSequence c = (CharSequence)carrier.getData();
        int nf = this.countNumberFeatures(c);
        if (this.numberFeatures == -1) {
            this.numberFeatures = nf;
        } else if (this.numberFeatures != nf) {
            throw new IllegalArgumentException("Instances must have same-length feature vectors. length_i: " + this.numberFeatures + " length_j: " + nf);
        }
        double[] feats = new double[this.numberFeatures];
        this.lexer.setCharSequence(c);
        int i = 0;
        while (this.lexer.hasNext()) {
            feats[i++] = Double.parseDouble((String)this.lexer.next());
        }
        carrier.setData(feats);
        return carrier;
    }

    private int countNumberFeatures(CharSequence c) {
        String s = ((Object)c).toString();
        int ret = 0;
        int pos = 0;
        while ((pos = s.indexOf(",", pos) + 1) != 0) {
            ++ret;
        }
        return ret + 1;
    }
}

