/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.definition.ComponentDefinitionsFactoryWrapper;
import org.apache.struts.util.RequestUtils;

public class TilesUtilImpl
implements Serializable {
    protected static final Log log = LogFactory.getLog(TilesUtil.class);
    public static final String DEFINITIONS_FACTORY = "org.apache.struts.tiles.DEFINITIONS_FACTORY";
    private static Method include = null;

    public void doForward(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        request.getRequestDispatcher(uri).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doInclude(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        request.getRequestDispatcher(uri).include((ServletRequest)request, (ServletResponse)response);
    }

    public void doInclude(String uri, PageContext pageContext, boolean flush) throws IOException, ServletException {
        try {
            if (include != null) {
                include.invoke((Object)pageContext, uri, flush);
                return;
            }
        }
        catch (IllegalAccessException e) {
            log.debug("Could not find JSP 2.0 include method.  Using old one.", e);
        }
        catch (InvocationTargetException e) {
            log.debug("Unable to execute JSP 2.0 include method.  Trying old one.", e);
        }
        pageContext.include(uri);
    }

    public DefinitionsFactory getDefinitionsFactory(ServletRequest request, ServletContext servletContext) {
        return (DefinitionsFactory)servletContext.getAttribute(DEFINITIONS_FACTORY);
    }

    public DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, DefinitionsFactoryConfig factoryConfig) throws DefinitionsFactoryException {
        DefinitionsFactory factory = this.createDefinitionFactoryInstance(factoryConfig.getFactoryClassname());
        factory.init(factoryConfig, servletContext);
        this.makeDefinitionsFactoryAccessible(factory, servletContext);
        return factory;
    }

    protected DefinitionsFactory createDefinitionFactoryInstance(String classname) throws DefinitionsFactoryException {
        try {
            Class factoryClass = RequestUtils.applicationClass(classname);
            Object factory = factoryClass.newInstance();
            if (factory instanceof ComponentDefinitionsFactory) {
                factory = new ComponentDefinitionsFactoryWrapper((ComponentDefinitionsFactory)factory);
            }
            return (DefinitionsFactory)factory;
        }
        catch (ClassCastException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Factory class '" + classname + " must implement 'TilesDefinitionsFactory'.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Bad class name '" + classname + "'.", ex);
        }
        catch (InstantiationException ex) {
            throw new DefinitionsFactoryException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new DefinitionsFactoryException(ex);
        }
    }

    protected void makeDefinitionsFactoryAccessible(DefinitionsFactory factory, ServletContext servletContext) {
        servletContext.setAttribute(DEFINITIONS_FACTORY, (Object)factory);
    }

    static {
        try {
            Class[] args = new Class[]{String.class, Boolean.TYPE};
            include = PageContext.class.getMethod("include", args);
        }
        catch (NoSuchMethodException e) {
            log.debug("Could not find JSP 2.0 include method.  Using old one that doesn't support configurable flushing.", e);
        }
    }
}

