/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.semantics;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.NotificationRegistry;
import org.apache.commons.scxml.PathResolver;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.SCXMLExpressionException;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.SCXMLSemantics;
import org.apache.commons.scxml.Step;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.invoke.Invoker;
import org.apache.commons.scxml.invoke.InvokerException;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.Executable;
import org.apache.commons.scxml.model.Finalize;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.Initial;
import org.apache.commons.scxml.model.Invoke;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.Param;
import org.apache.commons.scxml.model.Path;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.commons.scxml.semantics.TransitionTargetComparator;

public class SCXMLSemanticsImpl
implements SCXMLSemantics,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log appLog = LogFactory.getLog((Class)SCXMLSemantics.class);
    private TransitionTargetComparator targetComparator = new TransitionTargetComparator();
    private static final String NAMESPACES_KEY = "_ALL_NAMESPACES";
    private static final String ERR_ILLEGAL_ALLOC = ".error.illegalalloc";

    public SCXML normalizeStateMachine(SCXML input, ErrorReporter errRep) {
        return input;
    }

    public void determineInitialStates(SCXML input, Set targets, List entryList, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        TransitionTarget tmp = input.getInitialTarget();
        if (tmp == null) {
            errRep.onError("NO_INITIAL", "SCXML initialstate is missing!", input);
        } else {
            targets.add(tmp);
            this.determineTargetStates(targets, errRep, scInstance);
            Set onEntry = SCXMLHelper.getAncestorClosure(targets, null);
            Object[] oen = onEntry.toArray();
            onEntry.clear();
            Arrays.sort(oen, this.getTTComparator());
            List<Object> entering = Arrays.asList(oen);
            Collections.reverse(entering);
            entryList.addAll(entering);
        }
    }

    public void executeActions(Step step, SCXML stateMachine, EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        Executable oe;
        TransitionTarget tt;
        NotificationRegistry nr = scInstance.getNotificationRegistry();
        Collection internalEvents = step.getAfterStatus().getEvents();
        Map invokers = scInstance.getInvokers();
        Iterator i = step.getExitList().iterator();
        while (i.hasNext()) {
            tt = (TransitionTarget)i.next();
            oe = tt.getOnExit();
            try {
                Iterator onExitIter = oe.getActions().iterator();
                while (onExitIter.hasNext()) {
                    ((Action)onExitIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, internalEvents);
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), oe);
            }
            if (invokers.containsKey(tt)) {
                Invoker toCancel = (Invoker)invokers.get(tt);
                try {
                    toCancel.cancel();
                }
                catch (InvokerException ie) {
                    TriggerEvent te = new TriggerEvent(tt.getId() + ".invoke.cancel.failed", 5);
                    internalEvents.add(te);
                }
                invokers.remove(tt);
            }
            nr.fireOnExit(tt, tt);
            nr.fireOnExit(stateMachine, tt);
            TriggerEvent te = new TriggerEvent(tt.getId() + ".exit", 2);
            internalEvents.add(te);
        }
        i = step.getTransitList().iterator();
        while (i.hasNext()) {
            Transition t = (Transition)i.next();
            try {
                Iterator transitIter = t.getActions().iterator();
                while (transitIter.hasNext()) {
                    ((Action)transitIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, internalEvents);
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), t);
            }
            List rtargets = t.getRuntimeTargets();
            for (int j = 0; j < rtargets.size(); ++j) {
                TransitionTarget tt2 = (TransitionTarget)rtargets.get(j);
                nr.fireOnTransition(t, t.getParent(), tt2, t);
                nr.fireOnTransition(stateMachine, t.getParent(), tt2, t);
            }
        }
        i = step.getEntryList().iterator();
        while (i.hasNext()) {
            tt = (TransitionTarget)i.next();
            oe = tt.getOnEntry();
            try {
                Iterator onEntryIter = oe.getActions().iterator();
                while (onEntryIter.hasNext()) {
                    ((Action)onEntryIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, internalEvents);
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), oe);
            }
            nr.fireOnEntry(tt, tt);
            nr.fireOnEntry(stateMachine, tt);
            TriggerEvent te = new TriggerEvent(tt.getId() + ".entry", 2);
            internalEvents.add(te);
            if (!(tt instanceof State)) continue;
            State ts = (State)tt;
            Initial ini = ts.getInitial();
            if (ts.isComposite() && ini != null) {
                try {
                    Iterator iniIter = ini.getTransition().getActions().iterator();
                    while (iniIter.hasNext()) {
                        ((Action)iniIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, internalEvents);
                    }
                }
                catch (SCXMLExpressionException e) {
                    errRep.onError("EXPRESSION_ERROR", e.getMessage(), ini);
                }
            }
            if (!ts.isFinal()) continue;
            State parent = (State)ts.getParent();
            String prefix = "";
            if (parent != null) {
                prefix = parent.getId();
            }
            te = new TriggerEvent(prefix + ".done", 2);
            internalEvents.add(te);
            if (parent != null) {
                scInstance.setDone(parent, true);
            }
            if (parent == null || !parent.isRegion()) continue;
            Parallel p = (Parallel)parent.getParent();
            int finCount = 0;
            int pCount = p.getChildren().size();
            Iterator regions = p.getChildren().iterator();
            while (regions.hasNext()) {
                State reg = (State)regions.next();
                if (!scInstance.isDone(reg)) continue;
                ++finCount;
            }
            if (finCount != pCount) continue;
            te = new TriggerEvent(p.getId() + ".done", 2);
            internalEvents.add(te);
            scInstance.setDone(p, true);
            if (!stateMachine.isLegacy()) continue;
            te = new TriggerEvent(p.getParent().getId() + ".done", 2);
            internalEvents.add(te);
            scInstance.setDone(p.getParentState(), true);
        }
    }

    public void enumerateReachableTransitions(SCXML stateMachine, Step step, ErrorReporter errRep) {
        HashSet<Transition> transSet = new HashSet<Transition>();
        HashSet<TransitionTarget> stateSet = new HashSet<TransitionTarget>(step.getBeforeStatus().getStates());
        LinkedList<TransitionTarget> todoList = new LinkedList<TransitionTarget>(stateSet);
        while (!todoList.isEmpty()) {
            TransitionTarget tt = (TransitionTarget)todoList.removeFirst();
            Iterator i = tt.getTransitionsList().iterator();
            while (i.hasNext()) {
                Transition t = (Transition)i.next();
                if (transSet.contains(t)) continue;
                transSet.add(t);
                step.getTransitList().add(t);
            }
            TransitionTarget parent = tt.getParent();
            if (parent == null || stateSet.contains(parent)) continue;
            stateSet.add(parent);
            todoList.addLast(parent);
        }
        transSet.clear();
        stateSet.clear();
        todoList.clear();
    }

    public void filterTransitionsSet(Step step, EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        HashSet allEvents = new HashSet(step.getBeforeStatus().getEvents().size() + step.getExternalEvents().size());
        allEvents.addAll(step.getBeforeStatus().getEvents());
        allEvents.addAll(step.getExternalEvents());
        Iterator iter = scInstance.getInvokers().keySet().iterator();
        while (iter.hasNext()) {
            Finalize fn;
            State s = (State)iter.next();
            if (!this.finalizeMatch(s.getId(), allEvents) || (fn = s.getInvoke().getFinalize()) == null) continue;
            try {
                Iterator fnIter = fn.getActions().iterator();
                while (fnIter.hasNext()) {
                    ((Action)fnIter.next()).execute(evtDispatcher, errRep, scInstance, this.appLog, step.getAfterStatus().getEvents());
                }
            }
            catch (SCXMLExpressionException e) {
                errRep.onError("EXPRESSION_ERROR", e.getMessage(), fn);
            }
        }
        LinkedList<Transition> removeList = new LinkedList<Transition>();
        Iterator iter2 = step.getTransitList().iterator();
        while (iter2.hasNext()) {
            Boolean rslt;
            Transition t = (Transition)iter2.next();
            String event = t.getEvent();
            if (!this.eventMatch(event, allEvents)) {
                removeList.add(t);
                continue;
            }
            String expr = t.getCond();
            if (SCXMLHelper.isStringEmpty(expr)) {
                rslt = Boolean.TRUE;
            } else {
                try {
                    Context ctx = scInstance.getContext(t.getParent());
                    ctx.setLocal(NAMESPACES_KEY, t.getNamespaces());
                    rslt = scInstance.getEvaluator().evalCond(ctx, t.getCond());
                    ctx.setLocal(NAMESPACES_KEY, null);
                }
                catch (SCXMLExpressionException e) {
                    rslt = Boolean.FALSE;
                    errRep.onError("EXPRESSION_ERROR", e.getMessage(), t);
                }
            }
            if (rslt.booleanValue()) continue;
            removeList.add(t);
        }
        step.getTransitList().removeAll(removeList);
        allEvents.clear();
        removeList.clear();
        if (step.getTransitList().size() > 1) {
            Object[] trans = step.getTransitList().toArray();
            LinkedHashSet<Transition> nonDeterm = new LinkedHashSet<Transition>();
            block7: for (int i = 0; i < trans.length; ++i) {
                Transition t = (Transition)trans[i];
                TransitionTarget tsrc = t.getParent();
                for (int j = i + 1; j < trans.length; ++j) {
                    Transition t2 = (Transition)trans[j];
                    TransitionTarget t2src = t2.getParent();
                    if (SCXMLHelper.isDescendant(t2src, tsrc)) {
                        removeList.add(t);
                        continue block7;
                    }
                    if (SCXMLHelper.isDescendant(tsrc, t2src)) {
                        removeList.add(t2);
                        continue;
                    }
                    nonDeterm.add(t);
                    nonDeterm.add(t2);
                }
            }
            nonDeterm.removeAll(removeList);
            if (nonDeterm.size() > 0) {
                HashSet<TransitionTarget> regions = new HashSet<TransitionTarget>();
                Iterator iter3 = nonDeterm.iterator();
                while (iter3.hasNext()) {
                    Transition t = (Transition)iter3.next();
                    TransitionTarget parent = t.getParent();
                    if (regions.contains(parent)) {
                        removeList.add(t);
                        continue;
                    }
                    regions.add(parent);
                }
            }
            step.getTransitList().removeAll(removeList);
        }
    }

    public Set seedTargetSet(Set residual, List transitList, ErrorReporter errRep) {
        HashSet<State> seedSet = new HashSet<State>();
        HashSet regions = new HashSet();
        Iterator i = transitList.iterator();
        while (i.hasNext()) {
            Transition t = (Transition)i.next();
            if (t.getTargets().size() > 0) {
                seedSet.addAll(t.getTargets());
            }
            List paths = t.getPaths();
            for (int j = 0; j < paths.size(); ++j) {
                Path p = (Path)paths.get(j);
                if (!p.isCrossRegion()) continue;
                List regs = p.getRegionsEntered();
                Iterator k = regs.iterator();
                while (k.hasNext()) {
                    State region = (State)k.next();
                    regions.addAll(((Parallel)region.getParent()).getChildren());
                }
            }
        }
        Set<State> allStates = new HashSet<State>(residual);
        allStates.addAll(seedSet);
        allStates = SCXMLHelper.getAncestorClosure(allStates, null);
        regions.removeAll(allStates);
        Iterator i2 = regions.iterator();
        while (i2.hasNext()) {
            State reg = (State)i2.next();
            seedSet.add(reg);
        }
        return seedSet;
    }

    public void determineTargetStates(Set states, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        LinkedList<Parallel> wrkSet = new LinkedList<Parallel>(states);
        states.clear();
        while (!wrkSet.isEmpty()) {
            TransitionTarget tt = (TransitionTarget)wrkSet.removeFirst();
            if (tt instanceof State) {
                State st = (State)tt;
                if (st.isSimple()) {
                    states.add(st);
                    continue;
                }
                if (st.isOrthogonal()) {
                    wrkSet.addLast(st.getParallel());
                    continue;
                }
                List initialStates = st.getInitial().getTransition().getTargets();
                wrkSet.addAll(initialStates);
                continue;
            }
            if (tt instanceof Parallel) {
                Parallel prl = (Parallel)tt;
                Iterator i = prl.getChildren().iterator();
                while (i.hasNext()) {
                    wrkSet.addLast((Parallel)i.next());
                }
                continue;
            }
            if (tt instanceof History) {
                History h = (History)tt;
                if (scInstance.isEmpty(h)) {
                    wrkSet.addAll(h.getTransition().getRuntimeTargets());
                    continue;
                }
                wrkSet.addAll(scInstance.getLastConfiguration(h));
                continue;
            }
            throw new ModelException("Unknown TransitionTarget subclass:" + tt.getClass().getName());
        }
    }

    public void updateHistoryStates(Step step, ErrorReporter errRep, SCInstance scInstance) {
        Set oldState = step.getBeforeStatus().getStates();
        Iterator i = step.getExitList().iterator();
        while (i.hasNext()) {
            State s;
            Object o = i.next();
            if (!(o instanceof State) || !(s = (State)o).hasHistory()) continue;
            HashSet shallow = null;
            HashSet<State> deep = null;
            Iterator j = s.getHistory().iterator();
            while (j.hasNext()) {
                History h = (History)j.next();
                if (h.isDeep()) {
                    if (deep == null) {
                        deep = new HashSet<State>();
                        Iterator k = oldState.iterator();
                        while (k.hasNext()) {
                            State os = (State)k.next();
                            if (!SCXMLHelper.isDescendant(os, s)) continue;
                            deep.add(os);
                        }
                    }
                    scInstance.setLastConfiguration(h, deep);
                    continue;
                }
                if (shallow == null) {
                    shallow = new HashSet();
                    shallow.addAll(s.getChildren().values());
                    shallow.retainAll(SCXMLHelper.getAncestorClosure(oldState, null));
                }
                scInstance.setLastConfiguration(h, shallow);
            }
            shallow = null;
            deep = null;
        }
    }

    public void followTransitions(Step step, ErrorReporter errorReporter, SCInstance scInstance) throws ModelException {
        Set currentStates = step.getBeforeStatus().getStates();
        List transitions = step.getTransitList();
        HashSet exitedStates = new HashSet();
        Iterator i = transitions.iterator();
        while (i.hasNext()) {
            Transition t = (Transition)i.next();
            Set ext = SCXMLHelper.getStatesExited(t, currentStates);
            exitedStates.addAll(ext);
        }
        HashSet residual = new HashSet(currentStates);
        residual.removeAll(exitedStates);
        Set seedSet = this.seedTargetSet(residual, transitions, errorReporter);
        Set targetSet = step.getAfterStatus().getStates();
        targetSet.addAll(seedSet);
        this.determineTargetStates(targetSet, errorReporter, scInstance);
        Set entered = SCXMLHelper.getAncestorClosure(targetSet, seedSet);
        seedSet.clear();
        Iterator i2 = transitions.iterator();
        while (i2.hasNext()) {
            Transition t = (Transition)i2.next();
            List paths = t.getPaths();
            for (int j = 0; j < paths.size(); ++j) {
                Path p = (Path)paths.get(j);
                entered.addAll(p.getDownwardSegment());
            }
            List rtargets = t.getRuntimeTargets();
            for (int j = 0; j < rtargets.size(); ++j) {
                TransitionTarget tt = (TransitionTarget)rtargets.get(j);
                if (!(tt instanceof History)) continue;
                entered.remove(tt);
            }
        }
        targetSet.addAll(residual);
        residual.clear();
        if (!SCXMLHelper.isLegalConfig(targetSet, errorReporter)) {
            throw new ModelException("Illegal state machine configuration!");
        }
        Object[] oex = exitedStates.toArray();
        exitedStates.clear();
        Object[] oen = entered.toArray();
        entered.clear();
        Arrays.sort(oex, this.getTTComparator());
        Arrays.sort(oen, this.getTTComparator());
        step.getExitList().addAll(Arrays.asList(oex));
        List<Object> entering = Arrays.asList(oen);
        Collections.reverse(entering);
        step.getEntryList().addAll(entering);
        Iterator<Object> reset = entering.iterator();
        while (reset.hasNext()) {
            Object o = reset.next();
            if (!(o instanceof State)) continue;
            scInstance.setDone((State)o, false);
        }
    }

    public void processInvokes(TriggerEvent[] events, ErrorReporter errRep, SCInstance scInstance) throws ModelException {
        HashSet<TriggerEvent> allEvents = new HashSet<TriggerEvent>();
        allEvents.addAll(Arrays.asList(events));
        Iterator invokeIter = scInstance.getInvokers().entrySet().iterator();
        while (invokeIter.hasNext()) {
            Map.Entry iEntry = invokeIter.next();
            String parentId = ((TransitionTarget)iEntry.getKey()).getId();
            if (this.finalizeMatch(parentId, allEvents)) continue;
            Invoker inv = (Invoker)iEntry.getValue();
            try {
                inv.parentEvents(events);
            }
            catch (InvokerException ie) {
                this.appLog.error((Object)ie.getMessage(), (Throwable)ie);
                throw new ModelException(ie.getMessage(), ie.getCause());
            }
        }
    }

    public void initiateInvokes(Step step, ErrorReporter errRep, SCInstance scInstance) {
        Evaluator eval = scInstance.getEvaluator();
        Collection internalEvents = step.getAfterStatus().getEvents();
        Iterator iter = step.getAfterStatus().getStates().iterator();
        while (iter.hasNext()) {
            State s = (State)iter.next();
            Context ctx = scInstance.getContext(s);
            Invoke i = s.getInvoke();
            if (i == null || scInstance.getInvoker(s) != null) continue;
            String src = i.getSrc();
            if (src == null) {
                String srcexpr = i.getSrcexpr();
                Object srcObj = null;
                try {
                    ctx.setLocal(NAMESPACES_KEY, i.getNamespaces());
                    srcObj = eval.eval(ctx, srcexpr);
                    ctx.setLocal(NAMESPACES_KEY, null);
                    src = String.valueOf(srcObj);
                }
                catch (SCXMLExpressionException see) {
                    errRep.onError("EXPRESSION_ERROR", see.getMessage(), i);
                }
            }
            String source = src;
            PathResolver pr = i.getPathResolver();
            if (pr != null) {
                source = i.getPathResolver().resolvePath(src);
            }
            String ttype = i.getTargettype();
            Invoker inv = null;
            try {
                inv = scInstance.newInvoker(ttype);
            }
            catch (InvokerException ie) {
                TriggerEvent te = new TriggerEvent(s.getId() + ".invoke.failed", 5);
                internalEvents.add(te);
                continue;
            }
            inv.setParentStateId(s.getId());
            inv.setSCInstance(scInstance);
            List params = i.params();
            HashMap<String, Object> args = new HashMap<String, Object>();
            Iterator pIter = params.iterator();
            while (pIter.hasNext()) {
                Param p = (Param)pIter.next();
                String argExpr = p.getExpr();
                Object argValue = null;
                ctx.setLocal(NAMESPACES_KEY, p.getNamespaces());
                if (argExpr != null && argExpr.trim().length() > 0) {
                    try {
                        argValue = eval.eval(ctx, argExpr);
                    }
                    catch (SCXMLExpressionException see) {
                        errRep.onError("EXPRESSION_ERROR", see.getMessage(), i);
                    }
                } else {
                    try {
                        argValue = eval.evalLocation(ctx, p.getName());
                        if (argValue == null) {
                            TriggerEvent te = new TriggerEvent(s.getId() + ERR_ILLEGAL_ALLOC, 5);
                            internalEvents.add(te);
                        }
                    }
                    catch (SCXMLExpressionException see) {
                        errRep.onError("EXPRESSION_ERROR", see.getMessage(), i);
                    }
                }
                ctx.setLocal(NAMESPACES_KEY, null);
                args.put(p.getName(), argValue);
            }
            try {
                inv.invoke(source, args);
            }
            catch (InvokerException ie) {
                TriggerEvent te = new TriggerEvent(s.getId() + ".invoke.failed", 5);
                internalEvents.add(te);
                continue;
            }
            scInstance.setInvoker(s, inv);
        }
    }

    protected boolean eventMatch(String transEvent, Set eventOccurrences) {
        if (SCXMLHelper.isStringEmpty(transEvent)) {
            return true;
        }
        String trimTransEvent = transEvent.trim();
        Iterator i = eventOccurrences.iterator();
        while (i.hasNext()) {
            TriggerEvent te = (TriggerEvent)i.next();
            String event = te.getName();
            if (event == null) continue;
            String trimEvent = event.trim();
            if (trimEvent.equals(trimTransEvent)) {
                return true;
            }
            if (te.getType() != 2 && trimTransEvent.equals("*")) {
                return true;
            }
            if (!trimTransEvent.endsWith(".*") || !trimEvent.startsWith(trimTransEvent.substring(0, trimTransEvent.length() - 1))) continue;
            return true;
        }
        return false;
    }

    protected boolean finalizeMatch(String parentStateId, Set eventOccurrences) {
        String prefix = parentStateId + ".invoke.";
        Iterator i = eventOccurrences.iterator();
        while (i.hasNext()) {
            String evt = ((TriggerEvent)i.next()).getName();
            if (evt == null || !evt.trim().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected Comparator getTTComparator() {
        return this.targetComparator;
    }

    protected void setLog(Log log) {
        this.appLog = log;
    }

    protected Log getLog() {
        return this.appLog;
    }
}

