/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env.jsp;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.scxml.env.jsp.ELContext;

public final class RootContext
extends ELContext {
    private VariableResolver variableResolver;
    private static final String ERR_HOST_JSP_CTX_NULL = "Host JSP Context cannot be null";

    public RootContext(JspContext ctx) {
        if (ctx == null) {
            this.getLog().error((Object)ERR_HOST_JSP_CTX_NULL);
            throw new IllegalArgumentException(ERR_HOST_JSP_CTX_NULL);
        }
        this.variableResolver = ctx.getVariableResolver();
    }

    public Object get(String name) {
        Object value = super.get(name);
        if (value == null) {
            try {
                value = this.variableResolver.resolveVariable(name);
            }
            catch (ELException ele) {
                this.getLog().error((Object)ele.getMessage(), (Throwable)ele);
            }
        }
        return value;
    }

    public boolean has(String name) {
        boolean exists = super.has(name);
        Object value = null;
        if (!exists) {
            try {
                value = this.variableResolver.resolveVariable(name);
            }
            catch (ELException ele) {
                this.getLog().error((Object)ele.getMessage(), (Throwable)ele);
            }
            if (value != null) {
                exists = true;
            }
        }
        return exists;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException();
    }
}

