/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Map;
import org.apache.commons.text.translate.EntityArrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class EntityArraysTest {
    @Test
    public void testConstructorExists() {
        new EntityArrays();
    }

    @Test
    public void testForDuplicatedDeclaredMapKeys() throws Exception {
        String packageDirectory = EntityArraysTest.class.getPackage().getName().replace(".", "/");
        try (BufferedReader br = new BufferedReader(new FileReader("src/main/java/" + packageDirectory + "/EntityArrays.java"));){
            String line;
            int mapDeclarationCounter = 0;
            while ((line = br.readLine()) != null) {
                if (line.contains("new HashMap<>();")) {
                    mapDeclarationCounter = 0;
                    continue;
                }
                if (line.contains(".put(")) {
                    ++mapDeclarationCounter;
                    continue;
                }
                if (!line.contains("Collections.unmodifiableMap(initialMap);")) continue;
                String mapVariableName = line.split("=")[0].trim();
                Map mapValue = (Map)EntityArrays.class.getDeclaredField(mapVariableName).get(EntityArrays.class);
                Assertions.assertThat((int)mapValue.keySet().size()).isEqualTo(mapDeclarationCounter);
            }
        }
    }

    @Test
    public void testForDuplicateDeclaredMapValuesISO8859Map() {
        Assertions.assertThat(EntityArrays.ISO8859_1_ESCAPE.keySet()).hasSameSizeAs(EntityArrays.ISO8859_1_UNESCAPE.keySet());
    }

    @Test
    public void testISO8859Map() {
        this.testEscapeVsUnescapeMaps(EntityArrays.ISO8859_1_ESCAPE, EntityArrays.ISO8859_1_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesHtml40ExtendedMap() {
        Assertions.assertThat(EntityArrays.HTML40_EXTENDED_ESCAPE.keySet()).hasSameSizeAs(EntityArrays.HTML40_EXTENDED_UNESCAPE.keySet());
    }

    @Test
    public void testHtml40ExtendedMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.HTML40_EXTENDED_ESCAPE, EntityArrays.HTML40_EXTENDED_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesAposMap() {
        Assertions.assertThat(EntityArrays.APOS_ESCAPE.keySet()).hasSameSizeAs(EntityArrays.APOS_UNESCAPE.keySet());
    }

    @Test
    public void testAposMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.APOS_ESCAPE, EntityArrays.APOS_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesBasicMap() {
        Assertions.assertThat(EntityArrays.BASIC_ESCAPE.keySet()).hasSameSizeAs(EntityArrays.BASIC_UNESCAPE.keySet());
    }

    @Test
    public void testBasicMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.BASIC_ESCAPE, EntityArrays.BASIC_UNESCAPE);
    }

    @Test
    public void testForDuplicateDeclaredMapValuesJavaCtrlCharsMap() {
        Assertions.assertThat(EntityArrays.JAVA_CTRL_CHARS_ESCAPE.keySet()).hasSameSizeAs(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE.keySet());
    }

    @Test
    public void testJavaCntrlCharsMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.JAVA_CTRL_CHARS_ESCAPE, EntityArrays.JAVA_CTRL_CHARS_UNESCAPE);
    }

    private void testEscapeVsUnescapeMaps(Map<CharSequence, CharSequence> escapeMap, Map<CharSequence, CharSequence> unescapeMap) {
        for (CharSequence escapeKey : escapeMap.keySet()) {
            for (CharSequence unescapeKey : unescapeMap.keySet()) {
                if (escapeKey != unescapeMap.get(unescapeKey)) continue;
                Assertions.assertThat((CharSequence)unescapeKey).isEqualTo((Object)escapeMap.get(escapeKey));
            }
        }
    }
}

