/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.ode.TestProblemAbstract;
import org.apache.commons.math3.util.FastMath;

public class TestProblem1
extends TestProblemAbstract {
    private double[] y;

    public TestProblem1() {
        double[] y0 = new double[]{1.0, 0.1};
        this.setInitialConditions(0.0, y0);
        this.setFinalConditions(4.0);
        double[] errorScale = new double[]{1.0, 1.0};
        this.setErrorScale(errorScale);
        this.y = new double[y0.length];
    }

    public void doComputeDerivatives(double t, double[] y, double[] yDot) {
        for (int i = 0; i < this.getDimension(); ++i) {
            yDot[i] = -y[i];
        }
    }

    public double[] computeTheoreticalState(double t) {
        double c = FastMath.exp((double)(this.getInitialTime() - t));
        for (int i = 0; i < this.getDimension(); ++i) {
            this.y[i] = c * this.getInitialState()[i];
        }
        return this.y;
    }
}

