/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.interpolation.SmoothingPolynomialBicubicSplineInterpolator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public final class SmoothingPolynomialBicubicSplineInterpolatorTest {
    @Test
    public void testPreconditions() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5, 7.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5, 3.0};
        double[][] zval = new double[xval.length][yval.length];
        SmoothingPolynomialBicubicSplineInterpolator interpolator = new SmoothingPolynomialBicubicSplineInterpolator(0);
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        double[] wxval = new double[]{3.0, 2.0, 5.0, 6.5};
        try {
            p = interpolator.interpolate(wxval, yval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wyval = new double[]{-4.0, -3.0, -1.0, -1.0};
        try {
            p = interpolator.interpolate(xval, wyval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[][] wzval = new double[xval.length][yval.length + 1];
        try {
            p = interpolator.interpolate(xval, yval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wzval = new double[xval.length - 1][yval.length];
        try {
            p = interpolator.interpolate(xval, yval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wzval = new double[xval.length][yval.length - 1];
        try {
            p = interpolator.interpolate(xval, yval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testPlane() {
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x - 3.0 * y + 5.0 + (double)((int)FastMath.abs((double)(5.0 * x + 3.0 * y)) % 2 == 0 ? 1 : -1);
            }
        };
        SmoothingPolynomialBicubicSplineInterpolator interpolator = new SmoothingPolynomialBicubicSplineInterpolator(1);
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5, 7.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.0, 2.5, 3.5};
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        double x = 4.0;
        double y = -3.0;
        double expected = f.value(x, y);
        double result = p.value(x, y);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)2.0);
        x = 4.5;
        y = -1.5;
        expected = f.value(x, y);
        result = p.value(x, y);
        Assert.assertEquals((String)"half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)2.0);
        x = 3.5;
        y = -3.5;
        expected = f.value(x, y);
        result = p.value(x, y);
        Assert.assertEquals((String)"half-way between sample points (border of the patch)", (double)expected, (double)result, (double)2.0);
    }

    @Test
    public void testParaboloid() {
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x * x - 3.0 * y * y + 4.0 * x * y - 5.0 + (double)((int)FastMath.abs((double)(5.0 * x + 3.0 * y)) % 2 == 0 ? 1 : -1);
            }
        };
        SmoothingPolynomialBicubicSplineInterpolator interpolator = new SmoothingPolynomialBicubicSplineInterpolator(4);
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5, 7.5, 8.0};
        double[] yval = new double[]{-4.0, -3.0, -2.0, -1.0, 0.5, 2.5};
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        double x = 5.0;
        double y = 0.5;
        double expected = f.value(x, y);
        double result = p.value(x, y);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)2.0);
        x = 4.5;
        y = -1.5;
        expected = f.value(x, y);
        result = p.value(x, y);
        Assert.assertEquals((String)"half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)2.0);
        x = 3.5;
        y = -3.5;
        expected = f.value(x, y);
        result = p.value(x, y);
        Assert.assertEquals((String)"half-way between sample points (border of the patch)", (double)expected, (double)result, (double)2.0);
    }
}

