/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class Array2DRowRealMatrixTest {
    protected double[][] id = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    protected double[][] testData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}, {1.0, 0.0, 8.0}};
    protected double[][] testDataLU = new double[][]{{2.0, 5.0, 3.0}, {0.5, -2.5, 6.5}, {0.5, 0.2, 0.2}};
    protected double[][] testDataPlus2 = new double[][]{{3.0, 4.0, 5.0}, {4.0, 7.0, 5.0}, {3.0, 2.0, 10.0}};
    protected double[][] testDataMinus = new double[][]{{-1.0, -2.0, -3.0}, {-2.0, -5.0, -3.0}, {-1.0, 0.0, -8.0}};
    protected double[] testDataRow1 = new double[]{1.0, 2.0, 3.0};
    protected double[] testDataCol3 = new double[]{3.0, 3.0, 8.0};
    protected double[][] testDataInv = new double[][]{{-40.0, 16.0, 9.0}, {13.0, -5.0, -3.0}, {5.0, -2.0, -1.0}};
    protected double[] preMultTest = new double[]{8.0, 12.0, 33.0};
    protected double[][] testData2 = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}};
    protected double[][] testData2T = new double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 3.0}};
    protected double[][] testDataPlusInv = new double[][]{{-39.0, 18.0, 12.0}, {15.0, 0.0, 0.0}, {6.0, -2.0, 7.0}};
    protected double[][] luData = new double[][]{{2.0, 3.0, 3.0}, {0.0, 5.0, 7.0}, {6.0, 9.0, 8.0}};
    protected double[][] luDataLUDecomposition = new double[][]{{6.0, 9.0, 8.0}, {0.0, 5.0, 7.0}, {0.33333333333333, 0.0, 0.33333333333333}};
    protected double[][] singular = new double[][]{{2.0, 3.0}, {2.0, 3.0}};
    protected double[][] bigSingular = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 5.0, 3.0, 4.0}, {7.0, 3.0, 256.0, 1930.0}, {3.0, 7.0, 6.0, 8.0}};
    protected double[][] detData = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 10.0}};
    protected double[][] detData2 = new double[][]{{1.0, 3.0}, {2.0, 4.0}};
    protected double[] testVector = new double[]{1.0, 2.0, 3.0};
    protected double[] testVector2 = new double[]{1.0, 2.0, 3.0, 4.0};
    protected double[][] subTestData = new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.5, 2.5, 3.5, 4.5}, {2.0, 4.0, 6.0, 8.0}, {4.0, 5.0, 6.0, 7.0}};
    protected double[][] subRows02Cols13 = new double[][]{{2.0, 4.0}, {4.0, 8.0}};
    protected double[][] subRows03Cols12 = new double[][]{{2.0, 3.0}, {5.0, 6.0}};
    protected double[][] subRows03Cols123 = new double[][]{{2.0, 3.0, 4.0}, {5.0, 6.0, 7.0}};
    protected double[][] subRows20Cols123 = new double[][]{{4.0, 6.0, 8.0}, {2.0, 3.0, 4.0}};
    protected double[][] subRows31Cols31 = new double[][]{{7.0, 5.0}, {4.5, 2.5}};
    protected double[][] subRows01Cols23 = new double[][]{{3.0, 4.0}, {3.5, 4.5}};
    protected double[][] subRows23Cols00 = new double[][]{{2.0}, {4.0}};
    protected double[][] subRows00Cols33 = new double[][]{{4.0}};
    protected double[][] subRow0 = new double[][]{{1.0, 2.0, 3.0, 4.0}};
    protected double[][] subRow3 = new double[][]{{4.0, 5.0, 6.0, 7.0}};
    protected double[][] subColumn1 = new double[][]{{2.0}, {2.5}, {4.0}, {5.0}};
    protected double[][] subColumn3 = new double[][]{{4.0}, {4.5}, {8.0}, {7.0}};
    protected double entryTolerance = 1.0E-15;
    protected double normTolerance = 1.0E-13;
    protected double powerTolerance = 1.0E-15;
    private double[][] d3 = new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}};
    private double[][] d4 = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}};
    private double[][] d5 = new double[][]{{30.0}, {70.0}};

    @Test
    public void testDimensions() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(this.testData2);
        Assert.assertEquals((String)"testData row dimension", (long)3L, (long)m.getRowDimension());
        Assert.assertEquals((String)"testData column dimension", (long)3L, (long)m.getColumnDimension());
        Assert.assertTrue((String)"testData is square", (boolean)m.isSquare());
        Assert.assertEquals((String)"testData2 row dimension", (long)m2.getRowDimension(), (long)2L);
        Assert.assertEquals((String)"testData2 column dimension", (long)m2.getColumnDimension(), (long)3L);
        Assert.assertTrue((String)"testData2 is not square", (!m2.isSquare() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyFunctions() {
        Array2DRowRealMatrix m1 = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(m1.getData());
        Assert.assertEquals((Object)m2, (Object)m1);
        Array2DRowRealMatrix m3 = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m4 = new Array2DRowRealMatrix(m3.getData(), false);
        Assert.assertEquals((Object)m4, (Object)m3);
    }

    @Test
    public void testAdd() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix mInv = new Array2DRowRealMatrix(this.testDataInv);
        Array2DRowRealMatrix mPlusMInv = m.add(mInv);
        double[][] sumEntries = mPlusMInv.getData();
        for (int row = 0; row < m.getRowDimension(); ++row) {
            for (int col = 0; col < m.getColumnDimension(); ++col) {
                Assert.assertEquals((String)"sum entry entry", (double)this.testDataPlusInv[row][col], (double)sumEntries[row][col], (double)this.entryTolerance);
            }
        }
    }

    @Test
    public void testAddFail() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(this.testData2);
        try {
            m.add(m2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNorm() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(this.testData2);
        Assert.assertEquals((String)"testData norm", (double)14.0, (double)m.getNorm(), (double)this.entryTolerance);
        Assert.assertEquals((String)"testData2 norm", (double)7.0, (double)m2.getNorm(), (double)this.entryTolerance);
    }

    @Test
    public void testFrobeniusNorm() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(this.testData2);
        Assert.assertEquals((String)"testData Frobenius norm", (double)FastMath.sqrt((double)117.0), (double)m.getFrobeniusNorm(), (double)this.entryTolerance);
        Assert.assertEquals((String)"testData2 Frobenius norm", (double)FastMath.sqrt((double)52.0), (double)m2.getFrobeniusNorm(), (double)this.entryTolerance);
    }

    @Test
    public void testPlusMinus() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(this.testDataInv);
        TestUtils.assertEquals("m-n = m + -n", (RealMatrix)m.subtract(m2), m2.scalarMultiply(-1.0).add((RealMatrix)m), this.entryTolerance);
        try {
            m.subtract(new Array2DRowRealMatrix(this.testData2));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix mInv = new Array2DRowRealMatrix(this.testDataInv);
        Array2DRowRealMatrix identity = new Array2DRowRealMatrix(this.id);
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(this.testData2);
        TestUtils.assertEquals("inverse multiply", (RealMatrix)m.multiply(mInv), (RealMatrix)identity, this.entryTolerance);
        TestUtils.assertEquals("inverse multiply", (RealMatrix)mInv.multiply(m), (RealMatrix)identity, this.entryTolerance);
        TestUtils.assertEquals("identity multiply", (RealMatrix)m.multiply(identity), (RealMatrix)m, this.entryTolerance);
        TestUtils.assertEquals("identity multiply", (RealMatrix)identity.multiply(mInv), (RealMatrix)mInv, this.entryTolerance);
        TestUtils.assertEquals("identity multiply", (RealMatrix)m2.multiply(identity), (RealMatrix)m2, this.entryTolerance);
        try {
            m.multiply(new Array2DRowRealMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply2() {
        Array2DRowRealMatrix m3 = new Array2DRowRealMatrix(this.d3);
        Array2DRowRealMatrix m4 = new Array2DRowRealMatrix(this.d4);
        Array2DRowRealMatrix m5 = new Array2DRowRealMatrix(this.d5);
        TestUtils.assertEquals("m3*m4=m5", m3.multiply((RealMatrix)m4), (RealMatrix)m5, this.entryTolerance);
    }

    @Test
    public void testPower() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix mInv = new Array2DRowRealMatrix(this.testDataInv);
        Array2DRowRealMatrix mPlusInv = new Array2DRowRealMatrix(this.testDataPlusInv);
        Array2DRowRealMatrix identity = new Array2DRowRealMatrix(this.id);
        TestUtils.assertEquals("m^0", m.power(0), (RealMatrix)identity, this.entryTolerance);
        TestUtils.assertEquals("mInv^0", mInv.power(0), (RealMatrix)identity, this.entryTolerance);
        TestUtils.assertEquals("mPlusInv^0", mPlusInv.power(0), (RealMatrix)identity, this.entryTolerance);
        TestUtils.assertEquals("m^1", m.power(1), (RealMatrix)m, this.entryTolerance);
        TestUtils.assertEquals("mInv^1", mInv.power(1), (RealMatrix)mInv, this.entryTolerance);
        TestUtils.assertEquals("mPlusInv^1", mPlusInv.power(1), (RealMatrix)mPlusInv, this.entryTolerance);
        RealMatrix C1 = m.copy();
        RealMatrix C2 = mInv.copy();
        RealMatrix C3 = mPlusInv.copy();
        for (int i = 2; i <= 10; ++i) {
            C1 = C1.multiply((RealMatrix)m);
            C2 = C2.multiply((RealMatrix)mInv);
            C3 = C3.multiply((RealMatrix)mPlusInv);
            TestUtils.assertEquals("m^" + i, m.power(i), C1, this.entryTolerance);
            TestUtils.assertEquals("mInv^" + i, mInv.power(i), C2, this.entryTolerance);
            TestUtils.assertEquals("mPlusInv^" + i, mPlusInv.power(i), C3, this.entryTolerance);
        }
        try {
            Array2DRowRealMatrix mNotSquare = new Array2DRowRealMatrix(this.testData2T);
            mNotSquare.power(2);
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
        try {
            m.power(-1);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTrace() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.id);
        Assert.assertEquals((String)"identity trace", (double)3.0, (double)m.getTrace(), (double)this.entryTolerance);
        m = new Array2DRowRealMatrix(this.testData2);
        try {
            m.getTrace();
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testScalarAdd() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        TestUtils.assertEquals("scalar add", (RealMatrix)new Array2DRowRealMatrix(this.testDataPlus2), m.scalarAdd(2.0), this.entryTolerance);
    }

    @Test
    public void testOperate() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.id);
        TestUtils.assertEquals("identity operate", this.testVector, m.operate(this.testVector), this.entryTolerance);
        TestUtils.assertEquals("identity operate", this.testVector, m.operate((RealVector)new ArrayRealVector(this.testVector)).toArray(), this.entryTolerance);
        m = new Array2DRowRealMatrix(this.bigSingular);
        try {
            m.operate(this.testVector);
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMath209() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}}, false);
        double[] b = a.operate(new double[]{1.0, 1.0});
        Assert.assertEquals((long)a.getRowDimension(), (long)b.length);
        Assert.assertEquals((double)3.0, (double)b[0], (double)1.0E-12);
        Assert.assertEquals((double)7.0, (double)b[1], (double)1.0E-12);
        Assert.assertEquals((double)11.0, (double)b[2], (double)1.0E-12);
    }

    @Test
    public void testTranspose() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        RealMatrix mIT = new LUDecomposition((RealMatrix)m).getSolver().getInverse().transpose();
        RealMatrix mTI = new LUDecomposition(m.transpose()).getSolver().getInverse();
        TestUtils.assertEquals("inverse-transpose", mIT, mTI, this.normTolerance);
        m = new Array2DRowRealMatrix(this.testData2);
        Array2DRowRealMatrix mt = new Array2DRowRealMatrix(this.testData2T);
        TestUtils.assertEquals("transpose", (RealMatrix)mt, m.transpose(), this.normTolerance);
    }

    @Test
    public void testPremultiplyVector() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        TestUtils.assertEquals("premultiply", m.preMultiply(this.testVector), this.preMultTest, this.normTolerance);
        TestUtils.assertEquals("premultiply", m.preMultiply(new ArrayRealVector(this.testVector).toArray()), this.preMultTest, this.normTolerance);
        m = new Array2DRowRealMatrix(this.bigSingular);
        try {
            m.preMultiply(this.testVector);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPremultiply() {
        Array2DRowRealMatrix m3 = new Array2DRowRealMatrix(this.d3);
        Array2DRowRealMatrix m4 = new Array2DRowRealMatrix(this.d4);
        Array2DRowRealMatrix m5 = new Array2DRowRealMatrix(this.d5);
        TestUtils.assertEquals("m3*m4=m5", m4.preMultiply((RealMatrix)m3), (RealMatrix)m5, this.entryTolerance);
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix mInv = new Array2DRowRealMatrix(this.testDataInv);
        Array2DRowRealMatrix identity = new Array2DRowRealMatrix(this.id);
        TestUtils.assertEquals("inverse multiply", m.preMultiply((RealMatrix)mInv), (RealMatrix)identity, this.entryTolerance);
        TestUtils.assertEquals("inverse multiply", mInv.preMultiply((RealMatrix)m), (RealMatrix)identity, this.entryTolerance);
        TestUtils.assertEquals("identity multiply", m.preMultiply((RealMatrix)identity), (RealMatrix)m, this.entryTolerance);
        TestUtils.assertEquals("identity multiply", identity.preMultiply((RealMatrix)mInv), (RealMatrix)mInv, this.entryTolerance);
        try {
            m.preMultiply((RealMatrix)new Array2DRowRealMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetVectors() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        TestUtils.assertEquals("get row", m.getRow(0), this.testDataRow1, this.entryTolerance);
        TestUtils.assertEquals("get col", m.getColumn(2), this.testDataCol3, this.entryTolerance);
        try {
            m.getRow(10);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(-1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntry() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Assert.assertEquals((String)"get entry", (double)m.getEntry(0, 1), (double)2.0, (double)this.entryTolerance);
        try {
            m.getEntry(10, 4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testExamples() {
        double[][] matrixData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}};
        Array2DRowRealMatrix m = new Array2DRowRealMatrix((double[][])matrixData);
        double[][] matrixData2 = new double[][]{{1.0, 2.0}, {2.0, 5.0}, {1.0, 7.0}};
        Array2DRowRealMatrix n = new Array2DRowRealMatrix((double[][])matrixData2);
        RealMatrix p = m.multiply((RealMatrix)n);
        Assert.assertEquals((long)2L, (long)p.getRowDimension());
        Assert.assertEquals((long)2L, (long)p.getColumnDimension());
        RealMatrix pInverse = new LUDecomposition(p).getSolver().getInverse();
        Assert.assertEquals((long)2L, (long)pInverse.getRowDimension());
        Assert.assertEquals((long)2L, (long)pInverse.getColumnDimension());
        double[][] coefficientsData = new double[][]{{2.0, 3.0, -2.0}, {-1.0, 7.0, 6.0}, {4.0, -3.0, -5.0}};
        Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix((double[][])coefficientsData);
        ArrayRealVector constants = new ArrayRealVector(new double[]{1.0, -2.0, 1.0}, false);
        RealVector solution = new LUDecomposition((RealMatrix)coefficients).getSolver().solve((RealVector)constants);
        double cst0 = constants.getEntry(0);
        double cst1 = constants.getEntry(1);
        double cst2 = constants.getEntry(2);
        double sol0 = solution.getEntry(0);
        double sol1 = solution.getEntry(1);
        double sol2 = solution.getEntry(2);
        Assert.assertEquals((double)(2.0 * sol0 + 3.0 * sol1 - 2.0 * sol2), (double)cst0, (double)1.0E-12);
        Assert.assertEquals((double)(-1.0 * sol0 + 7.0 * sol1 + 6.0 * sol2), (double)cst1, (double)1.0E-12);
        Assert.assertEquals((double)(4.0 * sol0 - 3.0 * sol1 - 5.0 * sol2), (double)cst2, (double)1.0E-12);
    }

    @Test
    public void testGetSubMatrix() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows23Cols00, 2, 3, 0, 0, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows00Cols33, 0, 0, 3, 3, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows01Cols23, 0, 1, 2, 3, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows02Cols13, new int[]{0, 2}, new int[]{1, 3}, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows03Cols12, new int[]{0, 3}, new int[]{1, 2}, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows03Cols123, new int[]{0, 3}, new int[]{1, 2, 3}, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows20Cols123, new int[]{2, 0}, new int[]{1, 2, 3}, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1}, false);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1}, false);
        this.checkGetSubMatrix((RealMatrix)m, null, 1, 0, 2, 4, true);
        this.checkGetSubMatrix((RealMatrix)m, null, -1, 1, 2, 2, true);
        this.checkGetSubMatrix((RealMatrix)m, null, 1, 0, 2, 2, true);
        this.checkGetSubMatrix((RealMatrix)m, null, 1, 0, 2, 4, true);
        this.checkGetSubMatrix((RealMatrix)m, null, new int[0], new int[]{0}, true);
        this.checkGetSubMatrix((RealMatrix)m, null, new int[]{0}, new int[]{4}, true);
    }

    private void checkGetSubMatrix(RealMatrix m, double[][] reference, int startRow, int endRow, int startColumn, int endColumn, boolean mustFail) {
        block7: {
            try {
                RealMatrix sub = m.getSubMatrix(startRow, endRow, startColumn, endColumn);
                Assert.assertEquals((Object)new Array2DRowRealMatrix(reference), (Object)sub);
                if (mustFail) {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (mustFail) break block7;
                throw e;
            }
        }
    }

    private void checkGetSubMatrix(RealMatrix m, double[][] reference, int[] selectedRows, int[] selectedColumns, boolean mustFail) {
        block7: {
            try {
                RealMatrix sub = m.getSubMatrix(selectedRows, selectedColumns);
                Assert.assertEquals((Object)new Array2DRowRealMatrix(reference), (Object)sub);
                if (mustFail) {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (mustFail) break block7;
                throw e;
            }
        }
    }

    @Test
    public void testCopySubMatrix() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        this.checkCopy((RealMatrix)m, this.subRows23Cols00, 2, 3, 0, 0, false);
        this.checkCopy((RealMatrix)m, this.subRows00Cols33, 0, 0, 3, 3, false);
        this.checkCopy((RealMatrix)m, this.subRows01Cols23, 0, 1, 2, 3, false);
        this.checkCopy((RealMatrix)m, this.subRows02Cols13, new int[]{0, 2}, new int[]{1, 3}, false);
        this.checkCopy((RealMatrix)m, this.subRows03Cols12, new int[]{0, 3}, new int[]{1, 2}, false);
        this.checkCopy((RealMatrix)m, this.subRows03Cols123, new int[]{0, 3}, new int[]{1, 2, 3}, false);
        this.checkCopy((RealMatrix)m, this.subRows20Cols123, new int[]{2, 0}, new int[]{1, 2, 3}, false);
        this.checkCopy((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1}, false);
        this.checkCopy((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1}, false);
        this.checkCopy((RealMatrix)m, null, 1, 0, 2, 4, true);
        this.checkCopy((RealMatrix)m, null, -1, 1, 2, 2, true);
        this.checkCopy((RealMatrix)m, null, 1, 0, 2, 2, true);
        this.checkCopy((RealMatrix)m, null, 1, 0, 2, 4, true);
        this.checkCopy((RealMatrix)m, null, new int[0], new int[]{0}, true);
        this.checkCopy((RealMatrix)m, null, new int[]{0}, new int[]{4}, true);
        double[][] copy = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0}};
        this.checkCopy((RealMatrix)m, copy, 0, 1, 0, 2, true);
        this.checkCopy((RealMatrix)m, copy, new int[]{0, 1}, new int[]{0, 1, 2}, true);
    }

    private void checkCopy(RealMatrix m, double[][] reference, int startRow, int endRow, int startColumn, int endColumn, boolean mustFail) {
        block9: {
            try {
                double[][] sub = reference == null ? new double[1][1] : this.createIdenticalCopy(reference);
                m.copySubMatrix(startRow, endRow, startColumn, endColumn, sub);
                Assert.assertEquals((Object)new Array2DRowRealMatrix(reference), (Object)new Array2DRowRealMatrix(sub));
                if (mustFail) {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (MatrixDimensionMismatchException e) {
                if (mustFail) break block9;
                throw e;
            }
        }
    }

    private void checkCopy(RealMatrix m, double[][] reference, int[] selectedRows, int[] selectedColumns, boolean mustFail) {
        block9: {
            try {
                double[][] sub = reference == null ? new double[1][1] : this.createIdenticalCopy(reference);
                m.copySubMatrix(selectedRows, selectedColumns, sub);
                Assert.assertEquals((Object)new Array2DRowRealMatrix(reference), (Object)new Array2DRowRealMatrix(sub));
                if (mustFail) {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (!mustFail) {
                    throw e;
                }
            }
            catch (MatrixDimensionMismatchException e) {
                if (mustFail) break block9;
                throw e;
            }
        }
    }

    private double[][] createIdenticalCopy(double[][] matrix) {
        double[][] matrixCopy = new double[matrix.length][];
        for (int i = 0; i < matrixCopy.length; ++i) {
            matrixCopy[i] = new double[matrix[i].length];
        }
        return matrixCopy;
    }

    @Test
    public void testGetRowMatrix() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        Array2DRowRealMatrix mRow0 = new Array2DRowRealMatrix(this.subRow0);
        Array2DRowRealMatrix mRow3 = new Array2DRowRealMatrix(this.subRow3);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowMatrix(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowMatrix(3));
        try {
            m.getRowMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRowMatrix() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        Array2DRowRealMatrix mRow3 = new Array2DRowRealMatrix(this.subRow3);
        Assert.assertNotSame((Object)mRow3, (Object)m.getRowMatrix(0));
        m.setRowMatrix(0, (RealMatrix)mRow3);
        Assert.assertEquals((Object)mRow3, (Object)m.getRowMatrix(0));
        try {
            m.setRowMatrix(-1, (RealMatrix)mRow3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRowMatrix(0, (RealMatrix)m);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnMatrix() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        Array2DRowRealMatrix mColumn1 = new Array2DRowRealMatrix(this.subColumn1);
        Array2DRowRealMatrix mColumn3 = new Array2DRowRealMatrix(this.subColumn3);
        Assert.assertEquals((String)"Column1", (Object)mColumn1, (Object)m.getColumnMatrix(1));
        Assert.assertEquals((String)"Column3", (Object)mColumn3, (Object)m.getColumnMatrix(3));
        try {
            m.getColumnMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumnMatrix() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        Array2DRowRealMatrix mColumn3 = new Array2DRowRealMatrix(this.subColumn3);
        Assert.assertNotSame((Object)mColumn3, (Object)m.getColumnMatrix(1));
        m.setColumnMatrix(1, (RealMatrix)mColumn3);
        Assert.assertEquals((Object)mColumn3, (Object)m.getColumnMatrix(1));
        try {
            m.setColumnMatrix(-1, (RealMatrix)mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumnMatrix(0, (RealMatrix)m);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRowVector() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        ArrayRealVector mRow0 = new ArrayRealVector(this.subRow0[0]);
        ArrayRealVector mRow3 = new ArrayRealVector(this.subRow3[0]);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowVector(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowVector(3));
        try {
            m.getRowVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRowVector() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        ArrayRealVector mRow3 = new ArrayRealVector(this.subRow3[0]);
        Assert.assertNotSame((Object)mRow3, (Object)m.getRowMatrix(0));
        m.setRowVector(0, (RealVector)mRow3);
        Assert.assertEquals((Object)mRow3, (Object)m.getRowVector(0));
        try {
            m.setRowVector(-1, (RealVector)mRow3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRowVector(0, (RealVector)new ArrayRealVector(5));
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnVector() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        RealVector mColumn1 = this.columnToVector(this.subColumn1);
        RealVector mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertEquals((String)"Column1", (Object)mColumn1, (Object)m.getColumnVector(1));
        Assert.assertEquals((String)"Column3", (Object)mColumn3, (Object)m.getColumnVector(3));
        try {
            m.getColumnVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumnVector() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        RealVector mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertNotSame((Object)mColumn3, (Object)m.getColumnVector(1));
        m.setColumnVector(1, mColumn3);
        Assert.assertEquals((Object)mColumn3, (Object)m.getColumnVector(1));
        try {
            m.setColumnVector(-1, mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumnVector(0, (RealVector)new ArrayRealVector(5));
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    private RealVector columnToVector(double[][] column) {
        double[] data = new double[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return new ArrayRealVector(data, false);
    }

    @Test
    public void testGetRow() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        this.checkArrays(this.subRow0[0], m.getRow(0));
        this.checkArrays(this.subRow3[0], m.getRow(3));
        try {
            m.getRow(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRow(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRow() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        Assert.assertTrue((this.subRow3[0][0] != m.getRow(0)[0] ? 1 : 0) != 0);
        m.setRow(0, this.subRow3[0]);
        this.checkArrays(this.subRow3[0], m.getRow(0));
        try {
            m.setRow(-1, this.subRow3[0]);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRow(0, new double[5]);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumn() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        double[] mColumn1 = this.columnToArray(this.subColumn1);
        double[] mColumn3 = this.columnToArray(this.subColumn3);
        this.checkArrays(mColumn1, m.getColumn(1));
        this.checkArrays(mColumn3, m.getColumn(3));
        try {
            m.getColumn(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumn() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.subTestData);
        double[] mColumn3 = this.columnToArray(this.subColumn3);
        Assert.assertTrue((mColumn3[0] != m.getColumn(1)[0] ? 1 : 0) != 0);
        m.setColumn(1, mColumn3);
        this.checkArrays(mColumn3, m.getColumn(1));
        try {
            m.setColumn(-1, mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumn(0, new double[5]);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    private double[] columnToArray(double[][] column) {
        double[] data = new double[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return data;
    }

    private void checkArrays(double[] expected, double[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)actual[i], (double)0.0);
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Array2DRowRealMatrix m1 = (Array2DRowRealMatrix)m.copy();
        Array2DRowRealMatrix mt = (Array2DRowRealMatrix)m.transpose();
        Assert.assertTrue((m.hashCode() != mt.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)m.hashCode(), (long)m1.hashCode());
        Assert.assertEquals((Object)m, (Object)m);
        Assert.assertEquals((Object)m, (Object)m1);
        Assert.assertFalse((boolean)m.equals(null));
        Assert.assertFalse((boolean)m.equals((Object)mt));
        Assert.assertFalse((boolean)m.equals((Object)new Array2DRowRealMatrix(this.bigSingular)));
    }

    @Test
    public void testToString() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Assert.assertEquals((Object)"Array2DRowRealMatrix{{1.0,2.0,3.0},{2.0,5.0,3.0},{1.0,0.0,8.0}}", (Object)m.toString());
        m = new Array2DRowRealMatrix();
        Assert.assertEquals((Object)"Array2DRowRealMatrix{}", (Object)m.toString());
    }

    @Test
    public void testSetSubMatrix() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        m.setSubMatrix(this.detData2, 1, 1);
        RealMatrix expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {2.0, 1.0, 3.0}, {1.0, 2.0, 4.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix(this.detData2, 0, 0);
        expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 3.0, 3.0}, {2.0, 4.0, 3.0}, {1.0, 2.0, 4.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix(this.testDataPlus2, 0, 0);
        expected = MatrixUtils.createRealMatrix((double[][])new double[][]{{3.0, 4.0, 5.0}, {4.0, 7.0, 5.0}, {3.0, 2.0, 10.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        try {
            m.setSubMatrix(this.testData, 1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix(this.testData, -1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix(this.testData, 1, -1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])null, 1, 1);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        Array2DRowRealMatrix m2 = new Array2DRowRealMatrix();
        try {
            m2.setSubMatrix(this.testData, 0, 1);
            Assert.fail((String)"expecting MathIllegalStateException");
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            // empty catch block
        }
        try {
            m2.setSubMatrix(this.testData, 1, 0);
            Assert.fail((String)"expecting MathIllegalStateException");
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])new double[][]{{1.0}, {2.0, 3.0}}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])new double[][]{new double[0]}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWalk() {
        int j;
        int i;
        int rows = 150;
        int columns = 75;
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(rows, columns);
        m.walkInRowOrder((RealMatrixChangingVisitor)new SetVisitor());
        GetVisitor getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowRealMatrix(rows, columns);
        m.walkInRowOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
        m = new Array2DRowRealMatrix(rows, columns);
        m.walkInColumnOrder((RealMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowRealMatrix(rows, columns);
        m.walkInColumnOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
        m = new Array2DRowRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInRowOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInRowOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
        m = new Array2DRowRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInColumnOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new Array2DRowRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInColumnOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
    }

    @Test
    public void testSerial() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(this.testData);
        Assert.assertEquals((Object)m, (Object)TestUtils.serializeAndRecover(m));
    }

    protected void splitLU(RealMatrix lu, double[][] lowerData, double[][] upperData) {
        if (!lu.isSquare()) {
            throw new NonSquareMatrixException(lu.getRowDimension(), lu.getColumnDimension());
        }
        if (lowerData.length != lowerData[0].length) {
            throw new DimensionMismatchException(lowerData.length, lowerData[0].length);
        }
        if (upperData.length != upperData[0].length) {
            throw new DimensionMismatchException(upperData.length, upperData[0].length);
        }
        if (lowerData.length != upperData.length) {
            throw new DimensionMismatchException(lowerData.length, upperData.length);
        }
        if (lowerData.length != lu.getRowDimension()) {
            throw new DimensionMismatchException(lowerData.length, lu.getRowDimension());
        }
        int n = lu.getRowDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (j < i) {
                    lowerData[i][j] = lu.getEntry(i, j);
                    upperData[i][j] = 0.0;
                    continue;
                }
                if (i == j) {
                    lowerData[i][j] = 1.0;
                    upperData[i][j] = lu.getEntry(i, j);
                    continue;
                }
                lowerData[i][j] = 0.0;
                upperData[i][j] = lu.getEntry(i, j);
            }
        }
    }

    protected RealMatrix permuteRows(RealMatrix matrix, int[] permutation) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        if (matrix.getRowDimension() != permutation.length) {
            throw new DimensionMismatchException(matrix.getRowDimension(), permutation.length);
        }
        int n = matrix.getRowDimension();
        int m = matrix.getColumnDimension();
        double[][] out = new double[m][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                out[i][j] = matrix.getEntry(permutation[i], j);
            }
        }
        return new Array2DRowRealMatrix(out);
    }

    private static class GetVisitor
    extends DefaultRealMatrixPreservingVisitor {
        private int count = 0;

        private GetVisitor() {
        }

        public void visit(int i, int j, double value) {
            ++this.count;
            Assert.assertEquals((double)((double)i + (double)j / 1024.0), (double)value, (double)0.0);
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class SetVisitor
    extends DefaultRealMatrixChangingVisitor {
        private SetVisitor() {
        }

        public double visit(int i, int j, double value) {
            return (double)i + (double)j / 1024.0;
        }
    }
}

