/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import java.io.IOException;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.fitting.leastsquares.AbstractLeastSquaresOptimizerAbstractTest;
import org.apache.commons.math3.fitting.leastsquares.CircleVectorial;
import org.apache.commons.math3.fitting.leastsquares.GaussNewtonOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.junit.Test;

public class GaussNewtonOptimizerWithQRTest
extends AbstractLeastSquaresOptimizerAbstractTest {
    public int getMaxIterations() {
        return 1000;
    }

    public LeastSquaresOptimizer getOptimizer() {
        return new GaussNewtonOptimizer(GaussNewtonOptimizer.Decomposition.QR);
    }

    @Test
    public void testMoreEstimatedParametersUnsorted() {
        try {
            super.testMoreEstimatedParametersUnsorted();
            this.fail(this.optimizer);
        }
        catch (ConvergenceException convergenceException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxEvaluations() throws Exception {
        try {
            CircleVectorial circle = new CircleVectorial();
            circle.addPoint(30.0, 68.0);
            circle.addPoint(50.0, -6.0);
            circle.addPoint(110.0, -20.0);
            circle.addPoint(35.0, 15.0);
            circle.addPoint(45.0, 97.0);
            LeastSquaresProblem lsp = this.builder(circle).checkerPair((ConvergenceChecker)new SimpleVectorValueChecker(1.0E-30, 1.0E-30)).maxIterations(Integer.MAX_VALUE).start(new double[]{98.68, 47.345}).build();
            this.optimizer.optimize(lsp);
            this.fail(this.optimizer);
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testCircleFittingBadInit() {
        try {
            super.testCircleFittingBadInit();
            this.fail(this.optimizer);
        }
        catch (ConvergenceException convergenceException) {
            // empty catch block
        }
    }

    @Test
    public void testHahn1() throws IOException {
        try {
            super.testHahn1();
            this.fail(this.optimizer);
        }
        catch (ConvergenceException convergenceException) {
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }
}

