/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.txt;

import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.utils.AbstractTextFormatWriter;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;

public class TextFacetDefinitionWriter
extends AbstractTextFormatWriter {
    static final String CSV_SEPARATOR = ",";
    static final int CSV_FACET_VERTEX_COUNT = 3;
    static final String DEFAULT_VERTEX_COMPONENT_SEPARATOR = " ";
    static final String DEFAULT_VERTEX_SEPARATOR = "; ";
    static final int DEFAULT_FACET_VERTEX_COUNT = -1;
    private static final String DEFAULT_COMMENT_TOKEN = "# ";
    private String vertexComponentSeparator = " ";
    private String vertexSeparator = "; ";
    private int facetVertexCount = -1;
    private String commentToken = "# ";

    public TextFacetDefinitionWriter(Writer writer) {
        super(writer);
    }

    public String getVertexComponentSeparator() {
        return this.vertexComponentSeparator;
    }

    public void setVertexComponentSeparator(String sep) {
        this.vertexComponentSeparator = sep;
    }

    public String getVertexSeparator() {
        return this.vertexSeparator;
    }

    public void setVertexSeparator(String sep) {
        this.vertexSeparator = sep;
    }

    public int getFacetVertexCount() {
        return this.facetVertexCount;
    }

    public void setFacetVertexCount(int vertexCount) {
        if (vertexCount > -1 && vertexCount < 3) {
            throw new IllegalArgumentException("Facet vertex count must be less than 0 or greater than 2; was " + vertexCount);
        }
        this.facetVertexCount = Math.max(-1, vertexCount);
    }

    public String getCommentToken() {
        return this.commentToken;
    }

    public void setCommentToken(String commentToken) {
        if (commentToken != null) {
            if (commentToken.isEmpty()) {
                throw new IllegalArgumentException("Comment token cannot be empty");
            }
            if (Character.isWhitespace(commentToken.charAt(0))) {
                throw new IllegalArgumentException("Comment token cannot begin with whitespace");
            }
        }
        this.commentToken = commentToken;
    }

    public void writeComment(String comment) {
        if (this.commentToken == null) {
            throw new IllegalStateException("Cannot write comment: no comment token configured");
        }
        if (comment != null) {
            for (String line : comment.split("\\R")) {
                this.write(this.commentToken + line);
                this.writeNewLine();
            }
        }
    }

    public void writeBlankLine() {
        this.writeNewLine();
    }

    public void write(BoundarySource3D src) {
        try (Stream stream = src.boundaryStream();){
            Iterator it = stream.iterator();
            while (it.hasNext()) {
                this.write((PlaneConvexSubset)it.next());
            }
        }
    }

    public void write(PlaneConvexSubset convexSubset) {
        if (convexSubset.isInfinite()) {
            throw new IllegalArgumentException("Cannot write infinite convex subset");
        }
        if (this.facetVertexCount == 3) {
            for (Triangle3D tri : convexSubset.toTriangles()) {
                this.write(tri.getVertices());
            }
        } else {
            this.write(convexSubset.getVertices());
        }
    }

    public void write(FacetDefinition facet) {
        this.write(facet.getVertices());
    }

    public void write(List<Vector3D> vertices) {
        int size = vertices.size();
        if (size < 3) {
            throw new IllegalArgumentException("At least 3 vertices are required per facet; found " + size);
        }
        if (this.facetVertexCount > -1 && size != this.facetVertexCount) {
            throw new IllegalArgumentException("Writer requires " + this.facetVertexCount + " vertices per facet; found " + size);
        }
        Iterator<Vector3D> it = vertices.iterator();
        this.write(it.next());
        while (it.hasNext()) {
            this.write(this.vertexSeparator);
            this.write(it.next());
        }
        this.writeNewLine();
    }

    private void write(Vector3D vertex) {
        this.write(vertex.getX());
        this.write(this.vertexComponentSeparator);
        this.write(vertex.getY());
        this.write(this.vertexComponentSeparator);
        this.write(vertex.getZ());
    }

    public static TextFacetDefinitionWriter csvFormat(Writer writer) {
        TextFacetDefinitionWriter fdWriter = new TextFacetDefinitionWriter(writer);
        fdWriter.setVertexComponentSeparator(CSV_SEPARATOR);
        fdWriter.setVertexSeparator(CSV_SEPARATOR);
        fdWriter.setFacetVertexCount(3);
        fdWriter.setCommentToken(null);
        return fdWriter;
    }
}

