/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Exec34Test {
    private final Executor exec = DefaultExecutor.builder().get();
    private final File testDir = new File("src/test/scripts");
    private final File pingScript = TestUtil.resolveScriptFileForOS(this.testDir + "/ping");

    Exec34Test() {
    }

    @Test
    void testExec34Part1() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        ExecuteWatchdog watchdog = new ExecuteWatchdog(Integer.MAX_VALUE);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cmdLine, (ExecuteResultHandler)handler);
        Assertions.assertTrue((boolean)watchdog.isWatching());
        watchdog.destroyProcess();
        Assertions.assertTrue((boolean)watchdog.killedProcess(), (String)"Watchdog should have killed the process");
        Assertions.assertFalse((boolean)watchdog.isWatching(), (String)"Watchdog is no longer watching the process");
    }

    @Test
    void testExec34Part2() throws Exception {
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument("10");
        ExecuteWatchdog watchdog = new ExecuteWatchdog(5000L);
        DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
        this.exec.setWatchdog(watchdog);
        this.exec.execute(cmdLine, (ExecuteResultHandler)handler);
        handler.waitFor();
        Assertions.assertTrue((boolean)handler.hasResult(), (String)"Process has exited");
        Assertions.assertNotNull((Object)((Object)handler.getException()), (String)"Process was aborted");
        Assertions.assertTrue((boolean)watchdog.killedProcess(), (String)"Watchdog should have killed the process");
        Assertions.assertFalse((boolean)watchdog.isWatching(), (String)"Watchdog is no longer watching the process");
    }
}

