/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.event.AbstractTestConfigurationEvents;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.junit.Assert;
import org.junit.Test;

public class TestHierarchicalConfigurationEvents
extends AbstractTestConfigurationEvents {
    protected AbstractConfiguration createConfiguration() {
        return new HierarchicalConfiguration();
    }

    @Test
    public void testClearTreeEvent() {
        HierarchicalConfiguration hc = (HierarchicalConfiguration)this.config;
        String key = "event.property".substring(0, "event.property".indexOf(46));
        List nodes = hc.getExpressionEngine().query(hc.getRootNode(), key);
        hc.clearTree(key);
        this.l.checkEvent(10, key, null, true);
        this.l.checkEvent(10, key, nodes, false);
        this.l.done();
    }

    @Test
    public void testAddNodesEvent() {
        HierarchicalConfiguration hc = (HierarchicalConfiguration)this.config;
        ArrayList<DefaultConfigurationNode> nodes = new ArrayList<DefaultConfigurationNode>(1);
        nodes.add(new DefaultConfigurationNode("a_key", (Object)"a value"));
        hc.addNodes("event.test", nodes);
        this.l.checkEvent(11, "event.test", nodes, true);
        this.l.checkEvent(11, "event.test", nodes, false);
        this.l.done();
    }

    @Test
    public void testAddNodesEmptyEvent() {
        ((HierarchicalConfiguration)this.config).addNodes("event.test", new ArrayList());
        this.l.done();
    }

    @Test
    public void testSubnodeChangedEvent() {
        SubnodeConfiguration sub = ((HierarchicalConfiguration)this.config).configurationAt("event.property");
        sub.addProperty("newProp", (Object)"newValue");
        this.checkSubnodeEvent(this.l.nextEvent(12), true);
        this.checkSubnodeEvent(this.l.nextEvent(12), false);
        this.l.done();
    }

    private void checkSubnodeEvent(ConfigurationEvent event, boolean before) {
        Assert.assertEquals((String)"Wrong before flag of nesting event", (Object)before, (Object)event.isBeforeUpdate());
        Assert.assertTrue((String)"No subnode event found in value", (boolean)(event.getPropertyValue() instanceof ConfigurationEvent));
        ConfigurationEvent evSub = (ConfigurationEvent)event.getPropertyValue();
        Assert.assertEquals((String)"Wrong event type", (long)1L, (long)evSub.getType());
        Assert.assertEquals((String)"Wrong property name", (Object)"newProp", (Object)evSub.getPropertyName());
        Assert.assertEquals((String)"Wrong property value", (Object)"newValue", (Object)evSub.getPropertyValue());
        Assert.assertEquals((String)"Wrong before flag", (Object)before, (Object)evSub.isBeforeUpdate());
    }
}

